package com.bizvane.members.facade.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.List;

@Data
public class MembersSearchWithLabelsVo {

    @NotNull
    private Long sysCompanyId;

    @NotNull
    private Long brandId;

    @NotNull
    private List<String> memberCodeList;

    /**
     * 导购id
     */
    private Long staffId;

    @NotNull
    private Integer pageNum;

    @NotNull
    private Integer pageSize;

    /**
     * 隔离门店
     */
    private List<Long> serviceStoreIds;

    /**
     * 排序类型（1、按消费排序, 2、按积分排序）
     */

    private Integer orderType;

    /**
     *  是否降序(true: 降序排序)
     */
    private Boolean isDesc;

    /**
     * 按标签检索
     */
    private List<String> labelList;

    /**
     * 标签检索类型（1、普通标签, 2、品牌官方, 3、精准营销）
     */
    private Integer labelType;

    @ApiModelProperty(value = "性别",name = "gender",example = "")
    private List<Integer> genderList;

    @ApiModelProperty(value = "是否微信会员 1是，2否",name = "wxMembers",example = "")
    private Integer wxMembers;

    @ApiModelProperty(value = "是否关注公众号 1未关注 2关注中 3取消关注",name = "focusPublic",example = "")
    private Integer focusPublic;

    @ApiModelProperty(value = "等级id",name = "levelId",example = "")
    private List<Long> levelIdList;

    @ApiModelProperty(value = "好友属性",name = "isMember",example = "")
    private String isMember;
}
