package com.bizvane.members.facade.service.qywxapi;

import com.bizvane.members.facade.es.pojo.WxChannelInfoSearchPojo;
import com.bizvane.members.facade.vo.qywx.CompanyWxChannelInfoRequestInfo;
import com.bizvane.members.facade.vo.qywx.CompanyWxChannelInfoResponseInfo;
import com.bizvane.members.facade.vo.qywx.CompanyWxChannelMemberRequestInfo;
import com.bizvane.members.facade.vo.qywx.WxChannelAdvancedRequestVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;
import java.util.List;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface CompanyWxChannelApiService {

    @RequestMapping(value = "/api/companyWxChannel/advancedSearchChannel", method = RequestMethod.POST)
    ResponseData<PageInfo<WxChannelInfoSearchPojo>> advancedSearchChannel(@RequestBody @Valid WxChannelAdvancedRequestVO wxChannelAdvancedRequestVO);


    /**
     * 企微用
     *
     * @param companyWxChannelInfoRequestInfo
     * @return
     */
    @RequestMapping(value = "/api/companyWxChannel/queryAdvancedWx", method = RequestMethod.POST)
    ResponseData<List<CompanyWxChannelInfoResponseInfo>> queryAdvancedWx(@RequestBody @Valid CompanyWxChannelInfoRequestInfo companyWxChannelInfoRequestInfo);

    /**
     * 企微用
     *
     * @param companyWxChannelInfoRequestInfo
     * @return
     */
    @RequestMapping(value = "/api/companyWxChannel/queryWxChannelByMemberCodes", method = RequestMethod.POST)
    ResponseData<List<CompanyWxChannelInfoResponseInfo>> queryWxChannelByMemberCodesAndBrand(
            @RequestBody @Valid CompanyWxChannelMemberRequestInfo companyWxChannelInfoRequestInfo);
}
