package com.bizvane.members.facade.service.inner;

import com.bizvane.members.facade.models.IntegralRecordModel;
import com.bizvane.members.facade.models.bo.BatchInsertIntegralRecordBO;
import com.bizvane.members.facade.models.bo.BatchTaskBo;
import com.bizvane.members.facade.vo.*;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

public interface MbrIntegralBatchRecordService {

    //批量插入要调整的积分记录(不处理积分扣减/增加)
    ResponseData<BatchInsertIntegralRecordBO> batchInsertIntegralRecordBeforeProcess(BatchUpdateMemberIntegralVO batchUpdateMemberIntegralVO,SysAccountPO sysAccountPo);

    //异步处理积分
    void asyncProcessIntegral(BatchInsertIntegralRecordBO batchInsertIntegralRecordBO);



    ResponseData<BatchTaskBo> batchChangeIntegralTask(BatchMemberTaskVo batchMemberTaskVo, SysAccountPO sysAccountPo);


    void asyncBatchChangeIntegralTask(BatchMemberTaskVo batchMemberTaskVo, BatchTaskBo batchTaskBo);


    void asyncRetryChangeIntegralTask(BatchTaskBo batchTaskBo);




    ResponseData<BatchIntegralRecordResponseVO> selectBatchIntegralRecord(BatchIntegralRecordRequestVO batchIntegralRecordRequestVO, Long sysCompanyId, Long brandId);


    ResponseData<String> exportBatchIntegralRecord(BatchIntegralRecordRequestVO batchIntegralRecordRequestVO, SysAccountPO sysAccountPo);

    /**
     * 批量导入变更积分
     * @param batchIntegralVO
     * @param currentLoginUser
     * @return
     */
    ResponseData importBatchIntegral(ImportBatchIntegralVO batchIntegralVO, SysAccountPO currentLoginUser);

    /**
     * 保存手动调整积分至批量调整积分记录
     * @param integralRecordModel   积分流水
     * @param changeStatus
     * @param reason
     */
    void saveIntegerBatchRecord(IntegralRecordModel integralRecordModel, Integer changeStatus, String reason);

}
