package com.bizvane.members.facade.service.card.response;

import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.util.Date;

@Data
@Builder
@ToString
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode
public class PushMbrModel {


    /**
     * 基础信息
     */

    @ApiModelProperty(name = "appId", value = "appId")
    private String appId;

    @ApiModelProperty(name = "unionId",value = "unionId")
    private String unionId;

    @ApiModelProperty(name = "openId", value = "openId")
    private String openId;

    @ApiModelProperty(name = "wxNick", value = "微信昵称")
    private String wxNick;

    @ApiModelProperty(name = "headPortraits", value = "微信头像")
    private String headPortraits;

    @ApiModelProperty(name = "name", value = "姓名")
    private String name;

    @ApiModelProperty(name = "phone", value = "手机号")
    private String phone;

    @ApiModelProperty(name = "gender", value = "性别")
    private String gender;

    @ApiModelProperty(name = "birthday", value = "生日")
    private Date birthday;

    @ApiModelProperty(name = "province", value = "省份")
    private String province;

    @ApiModelProperty(name = "city", value = "城市")
    private String city;

    @ApiModelProperty(name = "county", value = "区县")
    private String county;

    @ApiModelProperty(name = "address", value = "详细地址")
    private String address;


    /**
     * 会员信息
     */

    @ApiModelProperty(name = "memberCode", value = "会员code")
    private String memberCode;

    @ApiModelProperty(name = "openCardTime", value = "开卡时间")
    private Date openCardTime;

    @ApiModelProperty(name = "levelName", value = "等级名称")
    private String levelName;

    @ApiModelProperty(name = "countIntegral", value = "累计可用积分")
    private Integer countIntegral;

    @ApiModelProperty(name = "cardNo", value = "线上卡号")
    private String cardNo;

    @ApiModelProperty(name = "offlineCardNo", value = "线下卡号")
    private String offlineCardNo;

    @ApiModelProperty(name = "storesName",value = "门店")
    private String storesName;

    @ApiModelProperty(value = "开卡导购id", name = "openCardGuideId")
    private Long openCardGuideId;

    @ApiModelProperty(value = "服务导购id", name = "serviceGuideId")
    private Long serviceGuideId;

    @ApiModelProperty(name = "cardStatus", value = "绑卡状态：1绑卡、2未帮卡")
    private Integer cardStatus;

    @ApiModelProperty(name = "operateType", value = "操作类型:0.已绑过,1绑卡，2注册")
    private Integer operateType;

    /**
     * 业务类型
     */
    @ApiModelProperty(name="sceneId",value="业务类型")
    private Long sceneId;
    @ApiModelProperty(name="sceneValue",value="业务类型值")
    private String sceneValue;

}
