package com.bizvane.members.facade.models;

import com.bizvane.wechatfacade.models.po.WxPublicPO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Created by Administrator on 2018\7\10 0010.
 * 微信渠道entity
 */
@Data
@NoArgsConstructor
@ToString
@EqualsAndHashCode
public class WxChannelInfoModel extends BaseModel implements Serializable {

    private static final long serialVersionUID = -8271703663854126738L;

    @ApiModelProperty(value = "微信渠道id", name = "mbrWxChannelId")
    private Long mbrWxChannelId;

    @ApiModelProperty(value = "会员code", name = "memberCode")
    private String memberCode;

    @ApiModelProperty(value = "品牌id", name = "brandId")
    private Long brandId;

    @ApiModelProperty(value = "企业id", name = "sysCompanyId")
    private Long sysCompanyId;

    @ApiModelProperty(value = "微信公众号id", name = "publicId")
    private Long publicId;

    @ApiModelProperty(value = "微信appId", name = "appId")
    private String appId;

    @ApiModelProperty(value = "微信unionId", name = "unionId")
    private String unionId;

    @ApiModelProperty(value = "微信openId", name = "openId")
    private String openId;

    @ApiModelProperty(value = "微信昵称", name = "wxNick")
    private String wxNick;

    @ApiModelProperty(name = "headPortraits", value = "微信头像")
    private String headPortraits;

    @ApiModelProperty(value = "会员性别", name = "gender")
    private String gender;

    @ApiModelProperty(value = "会员省份", name = "province")
    private String province;

    @ApiModelProperty(value = "会员城市", name = "city")
    private String city;

    @ApiModelProperty(value = "会员县", name = "county")
    private String county;

    @ApiModelProperty(value = "是否关注：1未关注，2已关注", name = "memberName")
    private Integer focus;

    @ApiModelProperty(value = "关注时间", name = "focusTime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date focusTime;

    @ApiModelProperty(value = "取关时间", name = "unFocusTime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date unFocusTime;

    @ApiModelProperty(value = "推荐人id", name = "referrerOpenId")
    private String referrerOpenId;
    
    @ApiModelProperty(value = "绑卡状态：1未邦卡，2已帮卡", name = "cardStatus")
    private Integer cardStatus;

    @ApiModelProperty(name = "miniProgram",value = "是否小程序：1微信2小程序")
    private Integer miniProgram;

    @ApiModelProperty(name = "openCardChannelCheck", value = "是否开卡渠道")
    private Integer openCardChannelCheck;

    @ApiModelProperty(name = "openCardGuideId" ,value = "开卡导购id")
    private Long openCardGuideId;

    @ApiModelProperty(name = "openCardStoreId", value = "开卡门店id")
    private Long openCardStoreId;

    @ApiModelProperty(name = "appIdList", value = "appId集合")
    private List<WxPublicPO> wxPublicPOList;
    
    @ApiModelProperty(name="channel",value="二维码渠道")
    private Integer channel;

    @ApiModelProperty(name = "wxBindStoreId",value = "微信绑卡店铺")
    private Long wxBindStoreId;

    @ApiModelProperty(name="wxBindGuideId",value="微信绑卡导购")
    private Long wxBindGuideId;

    @ApiModelProperty(name="wxBindTime",value="微信绑卡时间")
    private Date wxBindTime;

    @ApiModelProperty(name="lastChatTime",value="最后聊天时间")
    private Date lastChatTime;
    @ApiModelProperty(name="markRead",value="是否未读")
    private Integer markRead;
}
