package com.bizvane.members.facade.service.inner;

import com.bizvane.members.facade.es.pojo.MemberInfoWritePojo;
import com.bizvane.members.facade.es.pojo.qywx.FriendsPojo;
import com.bizvane.members.facade.es.pojo.qywx.MemberFlagPojo;
import com.bizvane.members.facade.es.pojo.qywx.WxChannelFlagPojo;
import com.bizvane.members.facade.es.pojo.qywx.WxQyFriendsPojoWritePojo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.WxChannelInfoModel;
import com.bizvane.members.facade.models.qywx.EsMbrFriendsModel;

public interface AsyncEsAndDbSaveService {
	/**
	 * 保存到会员es(memberCode primary key) protectFields标志位null依然会被写到es
	 *
	 * @param pojo
	 * @param protectFields
	 */
	void asyncSaveEsMembers(MemberInfoWritePojo pojo, String... protectFields);

	/**
	 * 保存到会员表(by memberCode) ，protectFields标志null依然会写
	 *
	 * @param memberInfoModel
	 * @param protectFields
	 */
	void asyncSaveDbMembers(MemberInfoModel memberInfoModel, String... protectFields);

	/**
	 * 根据memberCode 写到好友es中 ，protectField标志null依然会写
	 *
	 * @param memberFlagPojo
	 * @param protectFields
	 */
	void asyncSaveEsFriendsWithMemberCode(MemberFlagPojo memberFlagPojo, String... protectFields);

	/**
	 * 根据memberCode
	 *
	 * @param memberFlagPojo
	 * @param protectFields
	 */
	void asyncSaveDbFriendsWithMemberCode(MemberFlagPojo memberFlagPojo, String... protectFields);

	void asyncSaveEsFriendsOnMembersWithUnionIdAndBrandId(MemberFlagPojo memberFlagPojo, String... protectFields);

	void asyncSaveDbFriendsOnMembersWithUnionIdAndBrandId(MemberFlagPojo memberFlagPojo, String... protectFields);

	void asyncSaveEsFriendsOnWxWithUnionIdAndBrandId(WxChannelFlagPojo wxChannelFlagPojo, String... protectFields);

	void asyncSaveDbFriendsOnWxWithUnionIdAndBrandId(WxChannelFlagPojo wxChannelFlagPojo, String... protectFields);

	void asyncSaveEsFriendsOnWxWithMemberCode(WxChannelFlagPojo wxChannelFlagPojo, String... protectFields);

	void asyncSaveDbFriendsOnWxWithMemberCode(WxChannelFlagPojo wxChannelFlagPojo, String... protectFields);

	void asyncSaveEsFriends(WxQyFriendsPojoWritePojo wxQyFriendsPojoWritePojo);

	void syncSaveEsMembers(MemberInfoWritePojo pojo, String... protectFields);

	void syncSaveDbMembers(MemberInfoModel memberInfoModel, String... protectFields);

	void syncSaveEsFriendsWithMembers(MemberFlagPojo memberFlagPojo, String... protectFields);

	void syncSaveDbFriendsWithMembers(MemberFlagPojo memberFlagPojo, String... protectFields);

	void syncSaveEsFriendsOnMembersWithUnionIdAndBrandId(MemberFlagPojo memberFlagPojo, String... protectFields);

	void syncSaveDbFriendsOnMembersWithUnionIdAndBrandId(MemberFlagPojo memberFlagPojo, String... protectFields);

	void syncSaveEsFriendsOnWxWithUnionIdAndBrandId(WxChannelFlagPojo wxChannelFlagPojo, String... protectFields);

	void syncSaveDbFriendsOnWxWithUnionIdAndBrandId(WxChannelFlagPojo wxChannelFlagPojo, String... protectFields);

	void syncSaveEsFriendsOnWxWithMemberCode(WxChannelFlagPojo wxChannelFlagPojo, String... protectFields);

	void syncSaveDbFriendsOnWxWithMemberCode(WxChannelFlagPojo wxChannelFlagPojo, String... protectFields);

	void syncSaveEsFriends(WxQyFriendsPojoWritePojo wxQyFriendsPojoWritePojo);

	/**
	 * 异步写入会员表 insert(智慧门店使用)
	 *
	 * @param memberInfoModel
	 */
	void asyncInsertDbMembers(MemberInfoModel memberInfoModel);

	@Deprecated
	void asyncSaveFriendsAllAssignFieldWithMembers(MemberFlagPojo memberFlagPojo, String... protectField);


	void asyncUploadQiniuWx(WxChannelInfoModel wxChannelInfoModel);


	int syncSaveDbFriendsOnGuideIdAndBrandId(FriendsPojo friendsPojo);


	int	updateFriendsBySysCompanyIdAndGuideId(EsMbrFriendsModel record,EsMbrFriendsModel query,String... protectFields);

}
