package com.bizvane.members.facade.enums;

/**
 * 微信渠道枚举
 */
public enum WxChannelEnum {

    ALREADY_OPEN_CARD("1", "已开卡"),

    NOT_OPEN_CARD("2", "未开卡");

    private String code;

    private String msg;

    WxChannelEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }


    public static String getName(String code) {
        for (WxChannelEnum type : WxChannelEnum.values()) {
            if (code.equals(type.getCode())) {
                return type.getMsg();
            }
        }
        return "";
    }
}
