package com.bizvane.members.facade.service.inner;

import com.bizvane.centerstageservice.models.vo.StaffVo;
import com.bizvane.centerstageservice.models.vo.SysStoreVo;
import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.IntegralRecordModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.vo.*;
import com.bizvane.members.facade.vo.qywx.StaffHandleVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;

import java.util.List;
import java.util.Map;

public interface MemberInfoService {
    /**
     * 多条件分页查询（未禁用的）
     *
     * @param pageVo
     * @param map
     * @return
     * @throws MemberException
     */
    ResponseData <PageInfo<MemberInfoVo>> findAllByConditions(PageVo pageVo, Map map) throws MemberException;

    /**
     * 查询扩展属性列 列表  启用的
     * @param brandId
     * @return
     */
    public ResponseData queryExtendPropertyColumn(Long brandId) throws MemberException;
    /**
     * 根据主键查询扩展属性（未禁用的）
     *
     * @param memberInfoModel
     * @return
     * @throws MemberException
     */
    ResponseData <MemberInfoModel> findByMemberCode(MemberInfoModel memberInfoModel) throws MemberException;

    /**
     * 手动调整积分
     *
     * @param integralRecordModel
     * @return
     * @throws MemberException
     */
    ResponseData<Integer> manualChangeMemberIntegral(IntegralRecordModel integralRecordModel) throws MemberException;

    /**
     * 批量贴标签
     *
     * @param map
     * @return
     * @throws MemberException
     */
    ResponseData batchUpdateMemberLabel(List<String> membersCode, List <String> labelIds,List <String> labelNames,Map map) throws MemberException;

    /**
     * 批量修改服务门店
     *
     * @param batchUpdateMemberInfoVo
     * @return
     * @throws MemberException
     */
    ResponseData batchUpdateServiceStore(BatchUpdateMemberInfoVo batchUpdateMemberInfoVo) throws MemberException;

    /**
     * 批量修改服务导购
     *
     * @param batchUpdateMemberInfoVo
     * @return
     * @throws MemberException
     */
    ResponseData batchUpdateServiceGuide(BatchUpdateMemberInfoVo batchUpdateMemberInfoVo) throws MemberException;

    /**
     * 批量修改服务门店和导购
     * @param batchUpdateMemberInfoVo
     * @return
     * @throws MemberException
     */
    ResponseData batchUpdateServiceStoreAndGuide(BatchUpdateMemberInfoVo batchUpdateMemberInfoVo) throws MemberException;

    /**
     * 查询店铺信息
     *
     * @param sysStoreVO
     * @return
     * @throws MemberException
     */
    ResponseData<com.github.pagehelper.PageInfo<SysStoreVo>> findServiceStore(SysStoreVo sysStoreVO) throws MemberException;

    /**
     * 查询导购信息
     *
     * @param staffVO
     * @return
     * @throws MemberException
     */
    ResponseData<PageInfo<StaffVo>> findServiceGuide(StaffVo staffVO) throws MemberException;

    /**
     * 调整等级
     *
     * @param levelRecordVo
     * @return
     * @throws MemberException
     */
    ResponseData changeMemberLevel(LevelRecordVo levelRecordVo) throws MemberException;

    /**
     * 查询分销会员列表
     *
     * @param pageVo
     * @return
     */
    ResponseData<com.github.pagehelper.PageInfo<MemberInfoModel>> findDistributionMemberList(PageVo pageVo, DistributionMemberVo distributionMemberVo);

    /**
     * 启用禁用分销状态
     *
     * @param memberInfoModel
     * @return
     */
    ResponseData updateDistributionState(MemberInfoModel memberInfoModel);

    /**
     * 根据会员code查询会员积分
     *
     * @param memberCode
     * @return
     */
    ResponseData getIntegralByMemberCode(String memberCode);


    /**
     * 根据会员code查询会员等级
     *
     * @param memberCode
     * @return
     */
    ResponseData getLevelByMemberCode(String memberCode);

    /**
     * 获取服务门店名称
     *
     * @return
     */
    String getMemberServiceStoreName(Long id);

    /**
     * 获取服务导购名称
     *
     * @param id
     * @return
     */
    String getMemberServiceGuideName(Long id);

    /**
     * 查询标签组和标签列表
     * @param brandId
     * @return
     */
    ResponseData queryLabelList(Long brandId);
    
    /**
     * 手动分页查询 导出相关
     * @param limit
     * @param to
     * @return
     */
    List<MemberInfoModel> getMemberInfoWithLimitTo(Long limit,Long to);



    public int updateLabels(MemberInfoModel memberInfoModel, List<String> labelIds, List<String> labelNames, Map map);

    ResponseData<MemberInfoModel> findByMemberCodeList(List<String> memberCodeList,Long sysCompanyId,Long sysBrandId);


    ResponseData<String> staffHandle(StaffHandleVo staffHandleVo);
}
