package com.bizvane.members.facade.service.inner;

import java.util.Optional;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.MembersSysModel;
import com.bizvane.members.facade.vo.MembersSysVo;
import com.bizvane.members.facade.vo.taobao.TaoBaoMemberSysRequestVo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

/**
 * @author houkai
 */
public interface MemberSysService {

    /**
     * 新建会员卡体系
     *
     * @param membersSysModel
     * @return
     * @throws MemberException
     */
    ResponseData addMemberSys(MembersSysModel membersSysModel) throws MemberException;

    /**
     * 根据品牌查询会员卡体系详情
     *
     * @param brandId
     * @return
     */
    ResponseData<MembersSysModel> queryMemberSysInfo(long brandId);

    /**
     * 编辑会员卡体系
     *
     * @param membersSysModel
     * @return
     * @throws MemberException
     */
    ResponseData updateMemberSys(MembersSysModel membersSysModel) throws MemberException;

    /**
     * 根据会员信息生成会员卡号
     *
     * @param memberInfoModel
     * @return
     */
    String produceCarNo(MemberInfoModel memberInfoModel);

    /**
     * 保存会员卡体系
     *
     * @param membersSysModel
     * @param currentUser
     * @return
     */
    ResponseData saveMemberSys(MembersSysModel membersSysModel, SysAccountPO currentUser);
    
    
    /**
     * 保存智慧门店会员体系
     */
    ResponseData<String> saveOrUpdateTaoBaoMemberSys(TaoBaoMemberSysRequestVo taoBao,Optional<SysAccountPO> optional);
    
    /**
     * 查询授权状态
     * @return
     */
    ResponseData<Integer> queryAuthState(Long brandId);


    /**
     * 查询会员卡体系详情
     * @param sysCompanyId
     * @param brandId
     * @return
     */
    ResponseData<MembersSysVo> queryMemberSysInfo(long sysCompanyId, long brandId);

}
