package com.bizvane.members.facade.service.ur;

import com.bizvane.members.facade.ur.vo.*;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface UrOpenCardApiService {


    @RequestMapping(path = "/urOpenCard/memberRegister", method = RequestMethod.POST)
    ResponseData<UrMemberCardResponseVo> memberRegister(@RequestBody @Valid UrMemberCardRequestVo urMemberCardRequestVo);

    @RequestMapping(path = "/urOpenCard/memberQuery", method = RequestMethod.POST)
    ResponseData<UrMemberQueryResponseVo> memberQuery(@RequestBody @Valid UrMemberQueryRequestVo urMemberQueryRequestVo) throws Exception;

    @RequestMapping(path = "/urOpenCard/memberUpdateInfo", method = RequestMethod.POST)
    ResponseData<UrMemberUpdateInfoResponseVo> memberUpdateInfo(@RequestBody @Valid UrMemberUpdateInfoRequestVo urMemberUpdateInfoRequestVo);

    @RequestMapping(path = "/urOpenCard/memberUpdatePhone",method = RequestMethod.POST)
    ResponseData<UrMemberUpdatePhoneResponseVo> memberUpdatePhone(@RequestBody @Valid  UrMemberUpdatePhoneRequestVo urMemberUpdatePhoneRequestVo);
}
