package com.bizvane.members.facade.service.ur;

import com.bizvane.members.facade.ur.vo.MiniUrOrderRequestVo;
import com.bizvane.members.facade.ur.vo.MiniUrOrderResponseVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface UrOrderApiService {

    @RequestMapping(value = "/api/urOrder/getUrOrderRecord", method = RequestMethod.POST)
    ResponseData<PageInfo<MiniUrOrderResponseVo>> getUrOrderRecord(@RequestBody @Valid MiniUrOrderRequestVo miniUrOrderRequestVo);

}
