package com.bizvane.members.facade.service.ur;

import com.bizvane.members.facade.ur.vo.MemberRequestCardNoVo;
import com.bizvane.members.facade.ur.vo.MemberResponseCardNoVo;
import com.bizvane.members.facade.ur.vo.MembersEsRequestVo;
import com.bizvane.members.facade.ur.vo.MembersEsResponseVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;
import java.util.List;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface UrMemberApiService {

    /**
     * 根据卡号查询会员
     *
     * @param memberRequestCardNoVo
     * @return
     */
    @RequestMapping(value = "/api/urMembers/getMembersInfoByCardNo", method = RequestMethod.POST)
    ResponseData<MemberResponseCardNoVo> getMembersInfoByCardNo(@RequestBody @Valid MemberRequestCardNoVo memberRequestCardNoVo);

    /**
     * 高级搜索查询会员列表
     * @param membersEsRequestVo
     * @return
     */
    @RequestMapping(value = "/api/urMembers/getMembersInfoByCardNo", method = RequestMethod.POST)
    ResponseData<List<MembersEsResponseVo>> getMembersList(@RequestBody @Valid MembersEsRequestVo membersEsRequestVo);
}
