package com.bizvane.members.facade.service.api;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.ExtendPropertyModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.WxChannelInfoModel;
import com.bizvane.members.facade.models.bo.ExtendPropertyVipCardStyleBo;
import com.bizvane.members.facade.models.bo.MiniProgramPropertyVipCardShowBo;
import com.bizvane.members.facade.vo.*;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import java.util.List;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/7/31.
 */
@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface WxAppletApiService {
	/**
	 * 查询基本和扩展属性列表
	 * 
	 * @param extendPropertyVO
	 * @return
	 * @throws MemberException
	 */
	@Deprecated
	@RequestMapping(value = "/api/getBaseAndExtendPropertyList", method = RequestMethod.POST)
	public ResponseData<MemberExtendPropertyVO> getBaseAndExtendPropertyList(
			@RequestBody ExtendPropertyVO extendPropertyVO) throws MemberException;

	/**
	 * 装修提供
	 *
	 * 修改可见性 and 顺序 and 必填与否
	 *
	 * 修改基本和扩展属性
	 *
	 * @param memberExtendPropertyVO
	 * @return
	 * @throws MemberException
	 */
	@RequestMapping(value = "/api/updateBaseAndExtendPropertyList", method = RequestMethod.POST)
	public ResponseData updateBaseAndExtendPropertyList(@RequestBody MemberExtendPropertyVO memberExtendPropertyVO)
			throws MemberException;

	/**
	 * 根据memberCode和brandId查询会员基本和扩展属性信息 微信小程序 个人资料配置查询
	 *
	 * @param memberInfoModel
	 * @return
	 * @throws MemberException
	 */
	@RequestMapping(value = "/api/getBaseAndExtendPropertyValue", method = RequestMethod.POST)
	public ResponseData<PersonalDataVo> getBaseAndExtendPropertyValue(@RequestBody MemberInfoModel memberInfoModel)
			throws MemberException;

	/**
	 * 小程序提供
	 *
	 * 更新个人资料
	 *
	 * @param extendPropertyValueVO
	 * @return
	 * @throws MemberException
	 */
	@RequestMapping(value = "/api/updateBaseAndExtendPropertyValue", method = RequestMethod.POST)
	public ResponseData updateBaseAndExtendPropertyValue(@RequestBody ExtendPropertyValueVO extendPropertyValueVO)
			throws MemberException;

	@RequestMapping(value = "/api/getServiceStoreId")
	public ResponseData<Long> getServiceStoreId(@RequestParam(value = "memberCode") String memberCode);

	@RequestMapping(value = "/api/getOpenCardStoreId")
	public ResponseData<Long> getOpenCardStoreId(@RequestParam(value = "memberCode") String memberCode);

	@RequestMapping("/api/getOpenCardGuideId")
	public ResponseData<WxChannelInfoModel> getOpenCardGuideId(@RequestParam("appId") String appId,
			@RequestParam("openId") String openId, @RequestParam("brandId") Long brandId);

	/**
	 * 
	 * 会员卡样式扩展字段查询
	 */
	@Deprecated
	@RequestMapping(value = "/api/getBaseAndExtendPropertyListVipCardStyle", method = RequestMethod.POST)
	public ResponseData<MemberExtendPropertyVO> getBaseAndExtendPropertyListVipCardStyle(
			@RequestBody ExtendPropertyVO extendPropertyVO) throws MemberException;

	/**
	 * 会员卡装修样式是否展示
	 * 
	 * @param memberExtendPropertyVO
	 * @return
	 * @throws MemberException
	 */
	@Deprecated
	@RequestMapping(value = "/api/updateBaseAndExtendPropertyListVipCardStyle", method = RequestMethod.POST)
	public ResponseData<Integer> updateBaseAndExtendPropertyListVipCardStyle(
			@RequestBody MemberExtendPropertyVO memberExtendPropertyVO) throws MemberException;

	/**
	 * 根据memberCode和brandId查询会员基本和扩展属性信息 微信小程序 个人资料配置查询
	 *
	 * @param memberInfoModel
	 * @return
	 * @throws MemberException
	 */
	@Deprecated
	@RequestMapping(value = "/api/getBaseAndExtendPropertyValueVipCardStyle", method = RequestMethod.POST)
	public ResponseData<PersonalDataVo> getBaseAndExtendPropertyValueVipCardStyle(
			@RequestBody MemberInfoModel memberInfoModel) throws MemberException;

	/**
	 * 查品牌下基本属性
	 * 
	 * @param sysCompanyId
	 * @param brandId
	 * @return
	 * @throws MemberException
	 */
	@RequestMapping(value = "/api/getBasePropertyListVipCardStyle", method = RequestMethod.POST)
	public ResponseData<List<ExtendPropertyVipCardStyleBo>> getBasePropertyListVipCardStyle(
			@RequestParam("sysCompanyId") Long sysCompanyId, @RequestParam("brandId") Long brandId)
			throws MemberException;

	/**
	 * 查品牌拓展属性
	 * 
	 * @param sysCompanyId
	 * @param brandId
	 * @return
	 * @throws MemberException
	 */
	@RequestMapping(value = "/api/getExtendPropertyListVipCardStyle", method = RequestMethod.POST)
	public ResponseData<List<ExtendPropertyVipCardStyleBo>> getExtendPropertyListVipCardStyle(
			@RequestParam("sysCompanyId") Long sysCompanyId, @RequestParam("brandId") Long brandId)
			throws MemberException;

	/**
	 * 批量更新属性
	 * 
	 * @param extendPropertyVipCardBatchUpdateVo
	 * @return
	 * @throws MemberException
	 */
	@RequestMapping(value = "/api/batchUpdatePropertyVipCardStyle", method = RequestMethod.POST)
	public ResponseData<Integer> batchUpdatePropertyVipCardStyle(
			@RequestBody ExtendPropertyVipCardBatchUpdateVo extendPropertyVipCardBatchUpdateVo) throws MemberException;

	/**
	 * 小程序查询属性
	 * 
	 * @param brandId
	 * @param memberCode
	 * @return
	 */
	@RequestMapping(value = "/api/getMiniProgramPropertyVipCardShow", method = RequestMethod.POST)
	public ResponseData<List<MiniProgramPropertyVipCardShowBo>> getMiniProgramPropertyVipCardShow(
			@RequestParam("brandId") Long brandId, @RequestParam("memberCode") String memberCode);
	
	
	@RequestMapping(value="/api/updateOpenCardStoreIdByMemberCode",method=RequestMethod.POST)
	public ResponseData<Integer> updateOpenCardStoreIdByMemberCode(
			@RequestParam("openCardStoreId") Long openCardStoreId, @RequestParam("memberCode") String memberCode);

	/**
	 * 表单形式更新会员资料
	 * @param extendPropertyFormVO
	 * @return
	 * @throws MemberException
	 */
	@RequestMapping(value = "/api/updatePropertyValueForm", method = RequestMethod.POST)
	public ResponseData<Integer> updatePropertyValueForm(@RequestBody @Valid ExtendPropertyFormVO extendPropertyFormVO);

}
