package com.bizvane.members.facade.service.card;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.service.card.request.IntegralChangeRequestModel;
import com.bizvane.members.facade.service.card.response.IntegralChangeResponseModel;
import com.bizvane.utils.enumutils.SysResponseEnum;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.annotation.Transactional;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/8/18.
 */
@Slf4j
public abstract class ApiIntegralChangeServiceAbstract {


    /**
     * 验证数据有效性
     *
     * @param integralChangeRequestModel
     * @return
     */
    public abstract void validationData(IntegralChangeRequestModel integralChangeRequestModel);

    /**
     * 调用线下积分变动接口
     *
     * @param integralChangeRequestModel
     * @return
     */
    public abstract IntegralChangeResponseModel invokeOfflineChange(IntegralChangeRequestModel integralChangeRequestModel);

    /**
     * 积分变动操作
     *
     * @param integralChangeRequestModel
     * @return
     */
    @Transactional
    public IntegralChangeResponseModel integralChange(IntegralChangeRequestModel integralChangeRequestModel) {
        //验证数据有效性
        this.validationData(integralChangeRequestModel);

        //调用线下积分变动接口
        IntegralChangeResponseModel integralChangeResponseModel = this.invokeOfflineChange(integralChangeRequestModel);
        //线下操作成功返回
        if (SysResponseEnum.SUCCESS.getCode() == integralChangeResponseModel.getCode()) {
            try {
                integralChangeResponseModel = invokeOnlineSyncData(integralChangeRequestModel, integralChangeResponseModel);
                if (SysResponseEnum.SUCCESS.getCode() == integralChangeResponseModel.getCode() && StringUtils.isNotBlank(
                        integralChangeResponseModel.getIntegralAdjustId())) {
                    asyncProcessMessage(integralChangeResponseModel);
                }
                return integralChangeResponseModel;
            } catch (MemberException me) {
                log.error(me.getMessage());
                me.getStackTrace();
                integralChangeResponseModel = new IntegralChangeResponseModel();
                integralChangeResponseModel.setCode(SysResponseEnum.FAILED.getCode());
                integralChangeResponseModel.setMessage(me.getMessage());
            }
        }
        //线下操作失败返回
        log.error("线下操作失败返回信息: " + integralChangeResponseModel.toString());
        return integralChangeResponseModel;
    }


    /**
     * 同步线上数据
     *
     * @param integralChangeRequestModel
     */
    public abstract IntegralChangeResponseModel invokeOnlineSyncData(IntegralChangeRequestModel integralChangeRequestModel, IntegralChangeResponseModel integralChangeResponseModel);

    private void asyncProcessMessage(IntegralChangeResponseModel instance) {
        new Thread(() -> this.notifySendMessage(instance)).start();
    }

    //同步消息和活动任务
    protected abstract void notifySendMessage(IntegralChangeResponseModel instance) throws MemberException;
}
