package com.bizvane.members.facade.service.qywxapi;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.OrderModel;
import com.bizvane.members.facade.models.bo.CompanyExchangeIntegralBo;
import com.bizvane.members.facade.vo.BatchUpdateMemberInfoVo;
import com.bizvane.members.facade.vo.MemberCardInfoRes;
import com.bizvane.members.facade.vo.OrderApiVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @Author: houkai
 * @Date: 2018/11/5 14:22
 * @Description:
 */
@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface CompanyMemberApiService {
    /**
     * 会员详情查询
     *
     * @param memberInfoModel
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/companyMember/queryMemberCardInfo", method = RequestMethod.POST)
    ResponseData<MemberCardInfoRes> queryMemberCardInfo(@RequestBody MemberInfoModel memberInfoModel) throws MemberException;

    /**
     * 查询会员订单列表
     *
     * @param orderApiVo
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/companyMember/queryOrderList", method = RequestMethod.POST)
    ResponseData<PageInfo<OrderModel>> queryOrderList(@RequestBody OrderApiVo orderApiVo) throws MemberException;

    /**
     * 设置会员备注
     *
     * @param memberInfoModel
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/companyMember/updateMemberComment", method = RequestMethod.POST)
    ResponseData updateMemberComment(@RequestBody MemberInfoModel memberInfoModel) throws MemberException;

    /**
     * 根据品牌id和unionid查询会员信息
     *
     * @param memberInfoModel
     * @return
     */
    @RequestMapping(value = "/api/companyMember/queryMemberByUnionId", method = RequestMethod.POST)
    ResponseData<MemberInfoModel> queryMemberByUnionId(@RequestBody MemberInfoModel memberInfoModel);

    /**
     * 批量修改会员服务导购
     *
     * @param batchUpdateMemberInfoVo
     * @return
     */
    @RequestMapping(value = "/api/companyMember/batchUpdateServiceGuide", method = RequestMethod.POST)
    ResponseData batchUpdateServiceGuide(@RequestBody BatchUpdateMemberInfoVo batchUpdateMemberInfoVo);

    /**
     * 根据导购id和品牌id移除服务导购所属会员
     *
     * @param memberInfoModel
     * @return
     */
    @RequestMapping(value = "/api/companyMember/removeServiceGuide", method = RequestMethod.POST)
    ResponseData removeServiceGuide(@RequestBody MemberInfoModel memberInfoModel);

    /**
     * 查询导购下的会员数量
     *
     * @param brandId
     * @param serviceGuideId
     * @return
     */
    @RequestMapping(value = "/api/queryMemberCountByServiceGuide", method = RequestMethod.POST)
    ResponseData<Integer> queryMemberCountByServiceGuide(@RequestParam(value = "brandId") Long brandId, @RequestParam(value = "serviceGuideId") Long serviceGuideId);



}
