package com.bizvane.members.facade.service.qywxapi;

import com.bizvane.members.facade.models.bo.CompanyExchangeIntegralBo;
import com.bizvane.members.facade.vo.qywx.IntegralExchangeRequestVo;
import com.bizvane.utils.responseinfo.ResponseData;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface CompanyIntegralApiService {

    /**
     * 查询crm积分与有赞积分兑换关系
     *
     * @return
     */
    @RequestMapping(value = "/api/companyIntegral/queryYouZanExchangeIntegral", method = RequestMethod.POST)
    ResponseData<CompanyExchangeIntegralBo> queryYouZanExchangeIntegral(@RequestParam(value = "sysCompanyId") Long sysCompanyId, @RequestParam(value = "brandId") Long brandId);

    @RequestMapping(value = "/api/companyIntegral/convertYouZanExchangeIntegral", method = RequestMethod.POST)
    ResponseData<String> convertYouZanExchangeIntegral(@RequestBody @Valid IntegralExchangeRequestVo integralExchangeRequestVo);

}
