package com.bizvane.members.facade.service.qywxapi;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.bizvane.members.facade.es.pojo.qywx.WxQyFriendsPojo;
import com.bizvane.members.facade.es.vo.WxQyFriendsSearchVo;
import com.bizvane.members.facade.models.qywx.EsMbrFriendsModel;
import com.bizvane.members.facade.vo.qywx.FriendsInfoVo;
import com.bizvane.members.facade.vo.qywx.WxQyFriendsVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;

@FeignClient(value = "${feign.client.members.name}",path = "${feign.client.members.path}")
public interface WxFriendsApiService {

	// 添加多个好友，没有save 有则update
	@RequestMapping(value = "/api/wxFriendsApi/saveAndUpdateFriends", method = RequestMethod.POST)
	ResponseData<Integer> saveAndUpdateFriends(@RequestBody FriendsInfoVo friends);

	// 查我的好友
	@RequestMapping(value = "/api/wxFriendsApi/getWxQyFriendsList", method = RequestMethod.POST)
	ResponseData<PageInfo<WxQyFriendsPojo>> getWxQyFriendsList(@RequestBody WxQyFriendsSearchVo wxQyFriendsSearchVo);

	// 查好友详情
	@RequestMapping(value = "/api/wxFriendsApi/getEsMbrFriendsDetail", method = RequestMethod.POST)
	ResponseData<EsMbrFriendsModel> getEsMbrFriendsDetail(@RequestParam("esMbrFriendsId") Long esMbrFriendsId);

	// 设置好友备注
	@RequestMapping(value = "/api/wxFriendsApi/updateFriendsComment", method = RequestMethod.POST)
	@Deprecated
	ResponseData<Integer> updateFriendsComment(@RequestBody WxQyFriendsSearchVo wxQyFriendsSearchVo);
	
	//根据条件查询好友信息
	@RequestMapping(value="/api/wxFriendsApi/getWxQyFriendsModel",method=RequestMethod.POST)
	public ResponseData<EsMbrFriendsModel> getWxQyFriendsModel(@RequestBody WxQyFriendsVo wxQyFriendsVo);
}
