package com.bizvane.members.facade.service.inner;


import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MemberLabelTypeModel;
import com.bizvane.utils.responseinfo.ResponseData;

import java.util.List;

/**
 * @author houkai
 */
public interface MemberLabelGroupService {
    /**
     * 添加标签组
     *
     * @param memberLabelTypeModel
     * @return
     * @throws MemberException
     */
    ResponseData addLabelGroup(MemberLabelTypeModel memberLabelTypeModel) throws MemberException;

    /**
     * 查询企业品牌下所有标签组
     *
     * @param brandId
     * @return
     */
    ResponseData<List<MemberLabelTypeModel>> queryLabelGroupList(long brandId);

    /**
     * 编辑标签组
     *
     * @param memberLabelTypeModel
     * @return
     * @throws MemberException
     */
    ResponseData updateLabelGroupValid(MemberLabelTypeModel memberLabelTypeModel) throws MemberException;

    /**
     * 初始化标签管理页面
     *
     * @param brandId
     * @return
     */
    ResponseData queryLabelView(long brandId);

    /**
     * 查询标签分组详情
     *
     * @param labelGroupId
     * @return
     */
    ResponseData<MemberLabelTypeModel> queryLabelGroupInfo(long labelGroupId);

    /**
     * 编辑标签组
     *
     * @param memberLabelTypeModel
     * @return
     */
    ResponseData updateLabelGroup(MemberLabelTypeModel memberLabelTypeModel);
}
