/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.members.facade.service.datafetch.process;

import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;

public abstract class BaseFetchData<T, V> {
    private static final Logger log = LoggerFactory.getLogger(BaseFetchData.class);

    public final void dataFetch(String message, String topic) {
        try {
            log.info("enter MemberDataFetch messageBody:{} " + message);
            T t = this.messageToBean(message);
            log.info("\u8f6c\u6362\u5bf9\u8c61\u540e========{}", t);
            if (t == null) {
                log.error("\u7c7b\u8f6c\u6362\u5f02\u5e38,\u5bf9\u8c61\u4e3anull!");
                return;
            }
            ResponseData messageResponseData = this.verifyMessage(t, topic);
            log.info("\u9a8c\u8bc1\u662f\u5426\u88ab\u6d88\u8d39\uff0c\u7ed3\u679c\u4e3a{}", (Object)messageResponseData.getCode());
            if (SysResponseEnum.FAILED.getCode() == messageResponseData.getCode()) {
                return;
            }
            ResponseData<V> responseData = this.paramValidation(t, topic);
            if (SysResponseEnum.FAILED.getCode() == responseData.getCode()) {
                log.info("\u9a8c\u8bc1\u975e\u7a7a\u5b57\u6bb5\u51fa\u9519!");
                log.error(responseData.getMessage());
                return;
            }
            Object newObj = responseData.getData();
            if (newObj == null) {
                return;
            }
            V original = this.messageIsExist(t);
            log.info("\u5224\u65ad\u662f\u5426\u5b58\u5728\u8be5\u8bb0\u5f55\uff0c\u5b58\u5728\u4e3atrue\uff0c\u4e0d\u5b58\u5728\u4e3afalse\uff1a{}", (Object)(original != null ? 1 : 0));
            if (original == null) {
                try {
                    this.insertData(newObj, topic);
                }
                catch (DuplicateKeyException e) {
                    original = this.messageIsExist(t);
                    this.abnormalUpdateData(newObj, original, topic, t);
                }
                catch (Exception e) {
                    log.error("error:{}", (Throwable)e);
                }
            } else {
                this.updateData(newObj, original, topic);
            }
        }
        catch (Exception e) {
            log.error("error:{}", (Throwable)e);
        }
    }

    public abstract T messageToBean(String var1);

    public abstract ResponseData verifyMessage(T var1, String var2);

    public abstract ResponseData<V> paramValidation(T var1, String var2);

    public abstract V messageIsExist(T var1);

    public abstract int insertData(V var1, String var2);

    public abstract int updateData(V var1, V var2, String var3);

    public abstract int abnormalUpdateData(V var1, V var2, String var3, T var4);
}

