package com.bizvane.members.facade.service.qywxapi;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.bizvane.members.facade.models.qywx.FollowerReportModel;
import com.bizvane.members.facade.models.qywx.MemberReportModel;
import com.bizvane.members.facade.vo.qywx.FollowerReportVo;
import com.bizvane.members.facade.vo.qywx.MemberReportVo;

@FeignClient(value = "${feign.client.members.name}",path = "${feign.client.members.path}")
public interface WxReportApiService {
	@RequestMapping(value = "/api/wxReportApi/getWxFollowerReport", method = RequestMethod.POST)
	public FollowerReportModel getWxFollowerReport(@RequestBody FollowerReportVo followerReportVo);

	@RequestMapping(value = "/api/wxReportApi/getMemberReport", method = RequestMethod.POST)
	public MemberReportModel getMemberReport(@RequestBody MemberReportVo memberReportVo);
}
