package com.bizvane.members.facade.service.api;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.ExtendPropertyModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.WxChannelInfoModel;
import com.bizvane.members.facade.vo.ExtendPropertyVO;
import com.bizvane.members.facade.vo.ExtendPropertyValueVO;
import com.bizvane.members.facade.vo.MemberExtendPropertyVO;
import com.bizvane.members.facade.vo.PersonalDataVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/7/31.
 */
@FeignClient(value = "${feign.client.members.name}",path = "${feign.client.members.path}")
public interface WxAppletApiService {
    /**
     * 查询基本和扩展属性列表
     * @param extendPropertyVO
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/getBaseAndExtendPropertyList", method = RequestMethod.POST)
    public ResponseData<MemberExtendPropertyVO> getBaseAndExtendPropertyList(@RequestBody  ExtendPropertyVO extendPropertyVO) throws MemberException;

    /**
     * 装修提供
     *
     * 修改可见性  and 顺序 and 必填与否
     *
     * 修改基本和扩展属性
     *
     * @param memberExtendPropertyVO
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/updateBaseAndExtendPropertyList", method = RequestMethod.POST)
    public ResponseData updateBaseAndExtendPropertyList(@RequestBody MemberExtendPropertyVO memberExtendPropertyVO) throws MemberException;

    /**
     * 根据memberCode和brandId查询会员基本和扩展属性信息
     * 微信小程序  个人资料配置查询
     *
     * @param memberInfoModel
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/getBaseAndExtendPropertyValue", method = RequestMethod.POST)
    public ResponseData<PersonalDataVo> getBaseAndExtendPropertyValue(@RequestBody MemberInfoModel memberInfoModel) throws MemberException;

    /**
     * 小程序提供
     *
     * 更新个人资料
     *
     * @param extendPropertyValueVO
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/updateBaseAndExtendPropertyValue", method = RequestMethod.POST)
    public ResponseData updateBaseAndExtendPropertyValue(@RequestBody ExtendPropertyValueVO extendPropertyValueVO) throws MemberException;

    @RequestMapping(value = "/api/getServiceStoreId")
    public ResponseData<Long> getServiceStoreId(@RequestParam(value = "memberCode") String memberCode);
    
    @RequestMapping(value="/api/getOpenCardStoreId")
    public ResponseData<Long> getOpenCardStoreId(@RequestParam(value="memberCode")String memberCode);

    @RequestMapping("/api/getOpenCardGuideId")
    public ResponseData<WxChannelInfoModel> getOpenCardGuideId(@RequestParam("appId") String appId, @RequestParam("openId") String openId, @RequestParam("brandId") Long brandId);
    
}
