package com.bizvane.members.facade.enums;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/8/3.
 */
public enum GenderEnum {
    WOMAN(1,"女"),
    MAN(2,"男"),
    UNKNOWN(3,"未知");

    private Integer code;

    private String msg;

    GenderEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static String getGenderType(String code) {
        for (GenderEnum type : GenderEnum.values()) {
            if (code.equals(type.getCode())) {
                return type.getMsg();
            }
        }
        return "";
    }
    public static Integer getGenderCode(String msg) {
        for (GenderEnum type : GenderEnum.values()) {
            if (msg.equals(type.getMsg())) {
                return type.getCode();
            }
        }
        return 3;
    }
}
