package com.bizvane.members.facade.service.api;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.ExtendPropertyModel;
import com.bizvane.members.facade.vo.InitExtendDefVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/7/18.
 * 拓展参数接口，外部调用
 */
@FeignClient(value = "${feign.client.members.name}",path = "${feign.client.members.path}")
public interface ExtendPropertyApiService {

    /**
     * 获取拓展属性列表
     *
     * @param extendPropertyModel
     * @return
     */
    @RequestMapping(value = "/api/getExtendProperty", method = RequestMethod.POST)
    ResponseData<List<ExtendPropertyModel>> getExtendProperty(@RequestBody ExtendPropertyModel extendPropertyModel) throws MemberException;


    @RequestMapping(value = "/api/initExtendDefOne",method = RequestMethod.POST)
    ResponseData initExtendDefOne(@RequestBody InitExtendDefVo initExtendDefModel);
}
