/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.mall.utils.omaga;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class OGAWAHttpClientUtil {
    public static String post(String url, Map<String, String> paramMap) throws ClientProtocolException, IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).build();
        httpPost.setConfig(requestConfig);
        List<NameValuePair> formparams = OGAWAHttpClientUtil.setHttpParams(paramMap);
        UrlEncodedFormEntity param = new UrlEncodedFormEntity(formparams, "UTF-8");
        httpPost.setEntity((HttpEntity)param);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        String httpEntityContent = OGAWAHttpClientUtil.getHttpEntityContent(response);
        httpPost.abort();
        return httpEntityContent;
    }

    public static String post(String url, String data) throws ClientProtocolException, IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).build();
        httpPost.setConfig(requestConfig);
        httpPost.setHeader("Content-Type", "text/json; charset=utf-8");
        httpPost.setEntity((HttpEntity)new StringEntity(URLEncoder.encode(data, "UTF-8")));
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        String httpEntityContent = OGAWAHttpClientUtil.getHttpEntityContent(response);
        httpPost.abort();
        return httpEntityContent;
    }

    public static String postWsdl(String url, String data) throws ClientProtocolException, IOException {
        OkHttpClient client = new OkHttpClient();
        MediaType mediaType = MediaType.parse((String)"text/xml;charset=UTF-8");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)data);
        Request request = new Request.Builder().url(url).post(body).addHeader("content-type", "text/xml;charset=UTF-8").addHeader("soapaction", "\"\"").build();
        Response response = client.newCall(request).execute();
        return response.body().string();
    }

    public static String getMessage(String soapAttachment) throws Exception {
        if (soapAttachment != null && soapAttachment.length() > 0) {
            Document document = null;
            document = DocumentHelper.parseText((String)soapAttachment);
            Element root = document.getRootElement();
            List list = root.elements();
            Node node = (Node)((Element)root.elements().get(0)).content().get(0);
            return node.getStringValue();
        }
        throw new Exception("\u8c03\u7528wsdl\u5931\u8d25,\u89e3\u6790response error");
    }

    public static String get(String url) throws ClientProtocolException, IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet();
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).build();
        httpGet.setConfig(requestConfig);
        httpGet.setURI(URI.create(url));
        HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
        String httpEntityContent = OGAWAHttpClientUtil.getHttpEntityContent(response);
        httpGet.abort();
        return httpEntityContent;
    }

    public static String get(String url, Map<String, String> paramMap) throws ClientProtocolException, IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet();
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).build();
        httpGet.setConfig(requestConfig);
        List<NameValuePair> formparams = OGAWAHttpClientUtil.setHttpParams(paramMap);
        String param = URLEncodedUtils.format(formparams, (String)"UTF-8");
        httpGet.setURI(URI.create(url + "?" + param));
        HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
        String httpEntityContent = OGAWAHttpClientUtil.getHttpEntityContent(response);
        httpGet.abort();
        return httpEntityContent;
    }

    public static String put(String url, Map<String, String> paramMap) throws ClientProtocolException, IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPut httpPut = new HttpPut(url);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).build();
        httpPut.setConfig(requestConfig);
        List<NameValuePair> formparams = OGAWAHttpClientUtil.setHttpParams(paramMap);
        UrlEncodedFormEntity param = new UrlEncodedFormEntity(formparams, "UTF-8");
        httpPut.setEntity((HttpEntity)param);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPut);
        String httpEntityContent = OGAWAHttpClientUtil.getHttpEntityContent(response);
        httpPut.abort();
        return httpEntityContent;
    }

    public static String delete(String url) throws ClientProtocolException, IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpDelete httpDelete = new HttpDelete();
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).build();
        httpDelete.setConfig(requestConfig);
        httpDelete.setURI(URI.create(url));
        HttpResponse response = httpClient.execute((HttpUriRequest)httpDelete);
        String httpEntityContent = OGAWAHttpClientUtil.getHttpEntityContent(response);
        httpDelete.abort();
        return httpEntityContent;
    }

    public static String delete(String url, Map<String, String> paramMap) throws ClientProtocolException, IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpDelete httpDelete = new HttpDelete();
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).build();
        httpDelete.setConfig(requestConfig);
        List<NameValuePair> formparams = OGAWAHttpClientUtil.setHttpParams(paramMap);
        String param = URLEncodedUtils.format(formparams, (String)"UTF-8");
        httpDelete.setURI(URI.create(url + "?" + param));
        HttpResponse response = httpClient.execute((HttpUriRequest)httpDelete);
        String httpEntityContent = OGAWAHttpClientUtil.getHttpEntityContent(response);
        httpDelete.abort();
        return httpEntityContent;
    }

    private static List<NameValuePair> setHttpParams(Map<String, String> paramMap) {
        ArrayList<NameValuePair> formparams = new ArrayList<NameValuePair>();
        Set<Map.Entry<String, String>> set = paramMap.entrySet();
        for (Map.Entry<String, String> entry : set) {
            formparams.add((NameValuePair)new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        return formparams;
    }

    private static String getHttpEntityContent(HttpResponse response) throws IOException, UnsupportedEncodingException {
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            InputStream is = entity.getContent();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String line = br.readLine();
            StringBuilder sb = new StringBuilder();
            while (line != null) {
                sb.append(line + "\n");
                line = br.readLine();
            }
            return sb.toString();
        }
        return "";
    }
}

