/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.comsumer.config;

import com.bizvane.comsumer.config.ProducerConfig;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"spring.kafka.producer.client-id"})
@Component
public class KafkaProducerClient<K> {
    private KafkaProducer<K, String> producer;
    private ProducerRecord<K, String> producerRecord;
    private Properties props;
    private ProducerConfig producerConfig;

    @Autowired
    public KafkaProducerClient(ProducerConfig producerConfig) {
        this.producerConfig = producerConfig;
        this.init();
    }

    void init() {
        this.props = new Properties();
        this.props.setProperty("bootstrap.servers", this.producerConfig.getBootstrapservers());
        this.props.setProperty("client.id", this.producerConfig.getClientid());
        this.props.setProperty("batch.size", String.valueOf(this.producerConfig.getBatchsize()));
        this.props.setProperty("retries", String.valueOf(this.producerConfig.getRetries()));
        this.props.setProperty("buffer.memory", String.valueOf(this.producerConfig.getBuffermemory()));
        this.props.setProperty("key.serializer", this.producerConfig.getKeyserializer());
        this.props.setProperty("value.serializer", this.producerConfig.getValueserializer());
        this.props.setProperty("acks", this.producerConfig.getAcks());
        this.producer = new KafkaProducer(this.props);
    }

    public void send(String topic, K key, String content) {
        this.producerRecord = new ProducerRecord(topic, key, (Object)content);
        this.producer.send(this.producerRecord);
    }

    public void send(String topic, String content, Consumer<Future<RecordMetadata>> consumer) {
        this.producerRecord = new ProducerRecord(topic, (Object)content);
        consumer.accept(this.producer.send(this.producerRecord));
    }

    public void send(String topic, String content, Callback callback) {
        this.producerRecord = new ProducerRecord(topic, (Object)content);
        this.producer.send(this.producerRecord, callback);
    }

    public void close() {
        this.producer.close();
    }
}

