/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.airport.mall.api.service.impl;

import com.bizvane.airport.mall.api.bo.IntegralMallOrderPreparePayBO;
import com.bizvane.airport.mall.api.bo.PrepareOrderResBO;
import com.bizvane.airport.mall.api.service.OrderPayApiService;
import com.bizvane.members.feign.model.bo.MbrIntegralAddRequestParam;
import com.bizvane.members.feign.model.bo.MbrIntegralSubRequestParam;
import com.bizvane.members.feign.service.IntegralFeign;
import com.bizvane.payment.feign.api.ApiWechatPayFeign;
import com.bizvane.payment.feign.vo.req.PrepareOrderReqVO;
import com.bizvane.utils.enumutils.IntegralBusinessWayEnum;
import com.bizvane.utils.enumutils.IntegralMallPayTypeEnum;
import com.bizvane.utils.enumutils.IntegralMallProductTypeEnum;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.wechat.pay.java.service.payments.jsapi.model.PrepayWithRequestPaymentResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderPayApiServiceImpl
implements OrderPayApiService {
    @Autowired
    private ApiWechatPayFeign apiWechatPayFeign;
    @Autowired
    private IntegralFeign integralFeign;

    public ResponseData<PrepareOrderResBO> orderPrepay(IntegralMallOrderPreparePayBO bo) {
        PrepareOrderResBO prepareOrderResBO = new PrepareOrderResBO();
        if (IntegralMallPayTypeEnum.INTEGRAL_PAY.getType().equals(bo.getPayType()) || IntegralMallPayTypeEnum.INTEGRAL_WECHAT_PAY.getType().equals(bo.getPayType())) {
            MbrIntegralSubRequestParam requestParam = new MbrIntegralSubRequestParam();
            requestParam.setMbrMembersCode(bo.getMbrMemberCode());
            requestParam.setChangeIntegral(bo.getPayIntegralAmount());
            requestParam.setBusinessWay(IntegralMallProductTypeEnum.INTEGRAL_COUPON.getType().equals(bo.getProductType()) ? IntegralBusinessWayEnum.COUPON_SUB.getType() + "" : IntegralBusinessWayEnum.GOODS_SUB.getType() + "");
            requestParam.setChangeBills(bo.getOrderNo());
            requestParam.setChangeDetails(bo.getIntegralMallOrderCode());
            ResponseData integralPayRes = this.integralFeign.sub(requestParam);
            if (SysResponseEnum.SUCCESS.getCode() != integralPayRes.getCode()) {
                return new ResponseData(integralPayRes.getCode(), integralPayRes.getMessage(), null);
            }
            prepareOrderResBO.setMbrIntegralRecordCode((String)integralPayRes.getData());
        }
        if (IntegralMallPayTypeEnum.WECHAT_PAY.getType().equals(bo.getPayType()) || IntegralMallPayTypeEnum.INTEGRAL_WECHAT_PAY.getType().equals(bo.getPayType())) {
            PrepareOrderReqVO orderReqVO = new PrepareOrderReqVO();
            orderReqVO.setIntegralOrderCode(bo.getIntegralMallOrderCode());
            orderReqVO.setOpenid(bo.getMbrOpenid());
            orderReqVO.setAmount(Integer.valueOf(bo.getPayCashAmount().intValue()));
            orderReqVO.setDescription("\u79ef\u5206\u5546\u57ce\u8ba2\u5355\u652f\u4ed8");
            ResponseData moneyPayRes = this.apiWechatPayFeign.prepareOrder(orderReqVO);
            if (SysResponseEnum.SUCCESS.getCode() != moneyPayRes.getCode() && IntegralMallPayTypeEnum.WECHAT_PAY.getType().equals(bo.getPayType())) {
                return new ResponseData(moneyPayRes.getCode(), moneyPayRes.getMessage(), null);
            }
            if (SysResponseEnum.SUCCESS.getCode() != moneyPayRes.getCode() && IntegralMallPayTypeEnum.INTEGRAL_WECHAT_PAY.getType().equals(bo.getPayType())) {
                MbrIntegralAddRequestParam requestParam = new MbrIntegralAddRequestParam();
                requestParam.setMbrMembersCode(bo.getMbrMemberCode());
                requestParam.setChangeIntegral(bo.getPayIntegralAmount());
                requestParam.setBusinessWay(IntegralBusinessWayEnum.COUPON_REFUND_ADD.getType() + "");
                requestParam.setChangeBills(bo.getOrderNo());
                requestParam.setChangeDetails(bo.getIntegralMallOrderCode() + "_refund");
                ResponseData integralRefundPayRes = this.integralFeign.add(requestParam);
                if (SysResponseEnum.SUCCESS.getCode() == integralRefundPayRes.getCode()) {
                    prepareOrderResBO.setMbrIntegralRecordCode(null);
                }
                return new ResponseData(moneyPayRes.getCode(), moneyPayRes.getMessage(), null);
            }
            PrepayWithRequestPaymentResponse moneyPayResData = (PrepayWithRequestPaymentResponse)moneyPayRes.getData();
            prepareOrderResBO.setAppId(moneyPayResData.getAppId());
            prepareOrderResBO.setTimestamp(moneyPayResData.getTimeStamp());
            prepareOrderResBO.setNonceStr(moneyPayResData.getNonceStr());
            prepareOrderResBO.setPackageVal(moneyPayResData.getPackageVal());
            prepareOrderResBO.setSignType(moneyPayResData.getSignType());
            prepareOrderResBO.setPaySign(moneyPayResData.getPaySign());
        }
        return new ResponseData(SysResponseEnum.SUCCESS.getCode(), SysResponseEnum.SUCCESS.getMessage(), (Object)prepareOrderResBO);
    }
}

