/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.airport.mall.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.airport.mall.api.service.IntegralMallRefundOrderApiService;
import com.bizvane.airport.mall.domain.model.entity.IntegralMallOrderPO;
import com.bizvane.airport.mall.domain.model.entity.IntegralMallRefundOrderPO;
import com.bizvane.airport.mall.domain.service.IntegralMallOrderService;
import com.bizvane.airport.mall.domain.service.IntegralMallRefundOrderService;
import com.bizvane.airport.mall.feign.model.req.IntegralMallRefundOrderAddReq;
import com.bizvane.airport.mall.feign.model.req.IntegralMallRefundOrderCheckReq;
import com.bizvane.airport.mall.feign.model.req.IntegralMallRefundOrderPageReq;
import com.bizvane.airport.mall.feign.model.res.IntegralMallRefundOrderRes;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IntegralMallRefundOrderApiServiceImpl
implements IntegralMallRefundOrderApiService {
    @Autowired
    private IntegralMallOrderService integralMallOrderService;
    @Autowired
    private IntegralMallRefundOrderService integralMallRefundOrderService;

    public ResponseData<Boolean> add(IntegralMallRefundOrderAddReq reqVO) {
        IntegralMallOrderPO mallOrderPO = new IntegralMallOrderPO();
        mallOrderPO.setIntegralMallOrderCode(reqVO.getIntegralMallOrderCode());
        IntegralMallOrderPO orderPO = (IntegralMallOrderPO)this.integralMallOrderService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(IntegralMallOrderPO::getIntegralMallOrderCode, (Object)mallOrderPO.getIntegralMallOrderCode())).eq(IntegralMallOrderPO::getValid, (Object)Boolean.TRUE));
        if (orderPO == null) {
            return new ResponseData(SysResponseEnum.POINTS_MALL_ORDER_NOT_FOUND.getCode(), SysResponseEnum.POINTS_MALL_ORDER_NOT_FOUND.getMessage(), (Object)false);
        }
        IntegralMallRefundOrderPO po = this.buildIntegralMallRefundOrderPO(orderPO);
        po.setApplyType(reqVO.getApplyType());
        po.setApplyRemark(reqVO.getApplyRemark());
        po.setIntegralMallRefundOrderCode("123");
        po.setRefundOrderNo("123");
        po.setCreateUserCode(reqVO.getCreateUserCode());
        po.setCreateUserName(reqVO.getCreateUserName());
        boolean refundOrderSaveFlag = this.integralMallRefundOrderService.save((Object)po);
        return new ResponseData((Object)refundOrderSaveFlag);
    }

    @NotNull
    private IntegralMallRefundOrderPO buildIntegralMallRefundOrderPO(IntegralMallOrderPO orderPO) {
        IntegralMallRefundOrderPO po = new IntegralMallRefundOrderPO();
        po.setMbrMemberCode(orderPO.getMbrMemberCode());
        po.setMbrCardNo(orderPO.getMbrCardNo());
        po.setMbrName(orderPO.getMbrName());
        po.setMbrPhone(orderPO.getMbrPhone());
        po.setMbrLevelDefCode(orderPO.getMbrLevelDefCode());
        po.setMbrLevelDefName(orderPO.getMbrLevelDefName());
        po.setApplyDate(LocalDateTime.now());
        po.setIntegralMallOrderCode(orderPO.getIntegralMallOrderCode());
        po.setOriginOrderNo(orderPO.getOrderNo());
        po.setOrderIntegralProductCode(orderPO.getIntegralProductCode());
        po.setOrderProductNo(orderPO.getOrderProductNo());
        po.setOrderProductName(orderPO.getOrderProductName());
        po.setOrderExchangeNum(orderPO.getExchangeNum());
        po.setOrderPayType(orderPO.getPayType());
        po.setOrderPayIntegralAmount(orderPO.getPayIntegralAmount());
        po.setOrderPayCashAmount(orderPO.getPayCashAmount());
        po.setOrderExchangeTime(orderPO.getExchangeTime());
        po.setOrderIntegralOrderTradeRecordCode(orderPO.getIntegralOrderTradeRecordCode());
        po.setOrderTransactionId(orderPO.getTransactionId());
        po.setOrderMbrIntegralRecordCode(orderPO.getMbrIntegralRecordCode());
        return po;
    }

    public ResponseData<PageInfo<IntegralMallRefundOrderRes>> page(IntegralMallRefundOrderPageReq reqVO) {
        Page refundOrderPage = (Page)this.integralMallRefundOrderService.page((IPage)new Page((long)reqVO.getPageNum().intValue(), (long)reqVO.getPageSize().intValue()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(StringUtils.isNotBlank((CharSequence)reqVO.getMbrCardNo()), IntegralMallRefundOrderPO::getMbrCardNo, (Object)reqVO.getMbrCardNo())).eq(StringUtils.isNotBlank((CharSequence)reqVO.getMbrPhone()), IntegralMallRefundOrderPO::getMbrPhone, (Object)reqVO.getMbrPhone())).eq(StringUtils.isNotBlank((CharSequence)reqVO.getRefundOrderNo()), IntegralMallRefundOrderPO::getRefundOrderNo, (Object)reqVO.getRefundOrderNo())).eq(StringUtils.isNotBlank((CharSequence)reqVO.getOrderProductNo()), IntegralMallRefundOrderPO::getOrderProductNo, (Object)reqVO.getOrderProductNo())).eq(StringUtils.isNotBlank((CharSequence)reqVO.getOrderProductName()), IntegralMallRefundOrderPO::getOrderProductName, (Object)reqVO.getOrderProductName())).eq(reqVO.getOrderPayType() != null, IntegralMallRefundOrderPO::getOrderPayType, (Object)reqVO.getOrderPayType())).eq(reqVO.getState() != null, IntegralMallRefundOrderPO::getState, (Object)reqVO.getState())).between(reqVO.getStartApplyDate() != null && reqVO.getEndApplyDate() != null, IntegralMallRefundOrderPO::getApplyDate, (Object)reqVO.getStartApplyDate(), (Object)reqVO.getEndApplyDate())).between(reqVO.getStartCheckDate() != null && reqVO.getEndCheckDate() != null, IntegralMallRefundOrderPO::getCheckDate, (Object)reqVO.getStartCheckDate(), (Object)reqVO.getEndCheckDate()));
        if (refundOrderPage == null || CollectionUtils.isEmpty((Collection)refundOrderPage.getRecords())) {
            return new ResponseData((Object)new PageInfo(0, 0, 0L, new ArrayList()));
        }
        List resList = refundOrderPage.getRecords().stream().map(po -> {
            IntegralMallRefundOrderRes res = this.buildIntegralMallRefundOrderRes(po);
            return res;
        }).collect(Collectors.toList());
        return new ResponseData((Object)new PageInfo(Long.valueOf(refundOrderPage.getCurrent()).intValue(), Long.valueOf(refundOrderPage.getSize()).intValue(), refundOrderPage.getTotal(), resList));
    }

    @NotNull
    private IntegralMallRefundOrderRes buildIntegralMallRefundOrderRes(IntegralMallRefundOrderPO po) {
        IntegralMallRefundOrderRes res = new IntegralMallRefundOrderRes();
        res.setIntegralMallRefundOrderCode(po.getIntegralMallRefundOrderCode());
        res.setMbrMemberCode(po.getMbrMemberCode());
        res.setMbrCardNo(po.getMbrCardNo());
        res.setMbrPhone(po.getMbrPhone());
        res.setMbrLevelDefCode(po.getMbrLevelDefCode());
        res.setMbrLevelDefName(po.getMbrLevelDefName());
        res.setApplyDate(po.getApplyDate());
        res.setApplyType(po.getApplyType());
        res.setApplyRemark(po.getApplyRemark());
        res.setRefundOrderNo(po.getRefundOrderNo());
        res.setIntegralMallOrderCode(po.getIntegralMallOrderCode());
        res.setOrderIntegralProductCode(po.getOrderIntegralProductCode());
        res.setOrderProductNo(po.getOrderProductNo());
        res.setOrderProductName(po.getOrderProductName());
        res.setOrderExchangeNum(po.getOrderExchangeNum());
        res.setOrderPayType(po.getOrderPayType());
        res.setOrderPayIntegralAmount(po.getOrderPayIntegralAmount());
        res.setOrderPayCashAmount(po.getOrderPayCashAmount());
        res.setOrderExchangeTime(po.getOrderExchangeTime());
        res.setOrderIntegralOrderTradeRecordCode(po.getOrderIntegralOrderTradeRecordCode());
        res.setOrderTransactionId(po.getOrderTransactionId());
        res.setOrderMbrIntegralRecordCode(po.getOrderMbrIntegralRecordCode());
        res.setRefundCashAmount(po.getRefundCashAmount());
        res.setRefundIntegral(po.getRefundIntegral());
        res.setRefundIntegralExpiredDays(po.getRefundIntegralExpiredDays());
        res.setRefundIntegralExpiredTime(po.getRefundIntegralExpiredTime());
        res.setRefundIntegralOrderTradeRecordCode(po.getRefundIntegralOrderTradeRecordCode());
        res.setRefundTransactionId(po.getRefundTransactionId());
        res.setCheckRemark(po.getCheckRemark());
        res.setCheckUserCode(po.getCheckUserCode());
        res.setCheckUserName(po.getCheckUserName());
        res.setCheckDate(po.getCheckDate());
        res.setState(po.getState());
        return res;
    }

    public ResponseData<Boolean> check(IntegralMallRefundOrderCheckReq reqVO) {
        IntegralMallRefundOrderPO refundOrderUpdatePO = new IntegralMallRefundOrderPO();
        refundOrderUpdatePO.setIntegralMallRefundOrderCode(reqVO.getIntegralMallRefundOrderCode());
        refundOrderUpdatePO.setRefundCashAmount(reqVO.getRefundCashAmount());
        refundOrderUpdatePO.setRefundIntegral(reqVO.getRefundIntegral());
        refundOrderUpdatePO.setRefundIntegralExpiredDays(reqVO.getRefundIntegralExpiredDays());
        refundOrderUpdatePO.setRefundIntegralExpiredTime(reqVO.getRefundIntegralExpiredTime());
        refundOrderUpdatePO.setCheckRemark(reqVO.getCheckRemark());
        refundOrderUpdatePO.setCheckUserCode(reqVO.getCheckUserCode());
        refundOrderUpdatePO.setCheckUserName(reqVO.getCheckUserName());
        refundOrderUpdatePO.setModifiedUserCode(reqVO.getModifiedUserCode());
        refundOrderUpdatePO.setModifiedUserName(reqVO.getModifiedUserName());
        boolean updateFlag = this.integralMallRefundOrderService.update((Object)refundOrderUpdatePO, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(IntegralMallRefundOrderPO::getIntegralMallRefundOrderCode, (Object)reqVO.getIntegralMallRefundOrderCode())).eq(IntegralMallRefundOrderPO::getValid, (Object)Boolean.TRUE)).eq(IntegralMallRefundOrderPO::getState, (Object)1));
        if (!updateFlag) {
            return new ResponseData(SysResponseEnum.OPERATE_FAILED_UPDATE_ERROR.getCode(), SysResponseEnum.OPERATE_FAILED_UPDATE_ERROR.getMessage(), (Object)false);
        }
        return new ResponseData(SysResponseEnum.SUCCESS.getCode(), SysResponseEnum.SUCCESS.getMessage(), (Object)true);
    }
}

