/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.airport.mall.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.airport.mall.api.service.IntegralMallProductApiService;
import com.bizvane.airport.mall.domain.model.entity.IntegralProductPO;
import com.bizvane.airport.mall.domain.model.entity.IntegralProductSkuPO;
import com.bizvane.airport.mall.domain.service.IntegralProductService;
import com.bizvane.airport.mall.domain.service.IntegralProductSkuService;
import com.bizvane.airport.mall.feign.model.req.IntegralProductDetailReq;
import com.bizvane.airport.mall.feign.model.req.IntegralProductPageReq;
import com.bizvane.airport.mall.feign.model.req.IntegralProductSkuReq;
import com.bizvane.airport.mall.feign.model.req.IntegralProductStatusReq;
import com.bizvane.airport.mall.feign.model.res.IntegralProductDetailRes;
import com.bizvane.airport.mall.feign.model.res.IntegralProductPageRes;
import com.bizvane.airport.mall.feign.model.res.IntegralProductSkuRes;
import com.bizvane.utils.enumutils.IntegralMallProductTypeEnum;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IntegralMallProductApiServiceImpl
implements IntegralMallProductApiService {
    @Autowired
    private IntegralProductService integralProductService;
    @Autowired
    private IntegralProductSkuService integralProductSkuService;

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<Boolean> add(IntegralProductDetailReq reqVO) {
        if (IntegralMallProductTypeEnum.INTEGRAL_PRODUCT.getType().equals(reqVO.getProductType()) && CollectionUtils.isEmpty((Collection)reqVO.getSkuList())) {
            return new ResponseData(SysResponseEnum.SKU_CAN_NOT_BE_NULL_FOR_REAL_GOODS.getCode(), SysResponseEnum.SKU_CAN_NOT_BE_NULL_FOR_REAL_GOODS.getMessage(), (Object)false);
        }
        IntegralProductPO po = this.buildIntegralProductPO(reqVO);
        po.setCreateUserCode(reqVO.getCreateUserCode());
        po.setCreateUserName(reqVO.getCreateUserName());
        boolean saveProductFlag = this.integralProductService.save((Object)po);
        Assert.isTrue((boolean)saveProductFlag, (String)"\u4fdd\u5b58\u5546\u54c1\u4fe1\u606f\u5931\u8d25", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty((Collection)reqVO.getSkuList())) {
            return new ResponseData((Object)true);
        }
        List skuList = reqVO.getSkuList();
        List productSkuPOList = skuList.stream().map(skuReq -> {
            IntegralProductSkuPO skuPO = this.buildIntegralProductSkuPO(skuReq);
            skuPO.setIntegralProductCode(po.getIntegralProductCode());
            skuPO.setIntegralProductCode(reqVO.getIntegralProductCode());
            skuPO.setCreateUserCode(reqVO.getCreateUserCode());
            skuPO.setCreateUserName(reqVO.getCreateUserName());
            return skuPO;
        }).collect(Collectors.toList());
        boolean skuBatchSaveFlag = this.integralProductSkuService.saveBatch(productSkuPOList);
        Assert.isTrue((boolean)skuBatchSaveFlag, (String)"\u4fdd\u5b58\u5546\u54c1\u4fe1\u606f\u5931\u8d25", (Object[])new Object[0]);
        return new ResponseData((Object)skuBatchSaveFlag);
    }

    @NotNull
    private IntegralProductSkuPO buildIntegralProductSkuPO(IntegralProductSkuReq skuReq) {
        IntegralProductSkuPO skuPO = new IntegralProductSkuPO();
        skuPO.setSpecNames(skuReq.getSpecNames());
        skuPO.setSpecCodes(skuReq.getSpecCodes());
        skuPO.setSpecDescription(skuReq.getSpecDescription());
        skuPO.setSkuNo(skuReq.getSkuNo());
        skuPO.setIntegralPrice(skuReq.getIntegralPrice());
        skuPO.setCashPrice(skuReq.getCashPrice());
        skuPO.setStockNum(skuReq.getStockNum());
        skuPO.setRemainNum(skuReq.getRemainNum());
        skuPO.setRealExchangeNum(Integer.valueOf(0));
        skuPO.setHoldOrderNum(Integer.valueOf(0));
        skuPO.setEnabled(skuReq.getEnabled());
        return skuPO;
    }

    @NotNull
    private IntegralProductPO buildIntegralProductPO(IntegralProductDetailReq reqVO) {
        IntegralProductPO po = new IntegralProductPO();
        po.setAirportNoOrg(reqVO.getAirportNoOrg());
        po.setProductCategoryCode(reqVO.getProductCategoryCode());
        po.setProductNo(reqVO.getProductNo());
        po.setProductName(reqVO.getProductName());
        po.setProductMainImg(reqVO.getProductMainImg());
        po.setCarouselImg(reqVO.getCarouselImg());
        po.setPayType(reqVO.getPayType());
        po.setIntegralPrice(reqVO.getIntegralPrice());
        po.setCashPrice(reqVO.getCashPrice());
        po.setCostPrice(reqVO.getCostPrice());
        po.setCountPerLimit(reqVO.getCountPerLimit());
        po.setStockNum(reqVO.getStockNum());
        po.setVirtualExchangeNum(reqVO.getVirtualExchangeNum());
        po.setRemainNum(reqVO.getRemainNum());
        po.setRealExchangeNum(Integer.valueOf(0));
        po.setHoldOrderNum(Integer.valueOf(0));
        po.setMemberRangeType(reqVO.getMemberRangeType());
        po.setMemberLevelCode(reqVO.getMemberLevelCode());
        po.setSort(reqVO.getSort());
        po.setHotState(reqVO.getHotState());
        po.setExchangeDesc(reqVO.getExchangeDesc());
        po.setProductType(reqVO.getProductType());
        po.setProductCouponType(reqVO.getProductCouponType());
        po.setProductCouponCode(reqVO.getProductCouponCode());
        po.setState(reqVO.getState());
        po.setUpFixedTime(reqVO.getUpFixedTime());
        po.setDownFixedTime(reqVO.getDownFixedTime());
        po.setProductDetailContent(reqVO.getProductDetailContent());
        po.setDeliveryType(reqVO.getDeliveryType());
        po.setDeliveryPriceType(reqVO.getDeliveryPriceType());
        po.setDeliveryPrice(reqVO.getDeliveryPrice());
        return po;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<Boolean> update(IntegralProductDetailReq reqVO) {
        if (IntegralMallProductTypeEnum.INTEGRAL_PRODUCT.getType().equals(reqVO.getProductType()) && CollectionUtils.isEmpty((Collection)reqVO.getSkuList())) {
            return new ResponseData(SysResponseEnum.SKU_CAN_NOT_BE_NULL_FOR_REAL_GOODS.getCode(), SysResponseEnum.SKU_CAN_NOT_BE_NULL_FOR_REAL_GOODS.getMessage(), (Object)false);
        }
        IntegralProductPO po = this.buildIntegralProductPO(reqVO);
        po.setModifiedUserCode(reqVO.getModifiedUserCode());
        po.setModifiedUserName(reqVO.getModifiedUserName());
        boolean updateProductFlag = this.integralProductService.update((Object)po, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(IntegralProductPO::getIntegralProductCode, (Object)reqVO.getIntegralProductCode())).eq(IntegralProductPO::getValid, (Object)Boolean.TRUE));
        Assert.isTrue((boolean)updateProductFlag, (String)"\u4fdd\u5b58\u5546\u54c1\u4fe1\u606f\u5931\u8d25", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty((Collection)reqVO.getSkuList())) {
            return new ResponseData((Object)true);
        }
        IntegralProductSkuPO integralProductSkuPOUpdate = new IntegralProductSkuPO();
        integralProductSkuPOUpdate.setValid(Boolean.FALSE);
        integralProductSkuPOUpdate.setModifiedUserCode(reqVO.getModifiedUserCode());
        integralProductSkuPOUpdate.setModifiedUserName(reqVO.getModifiedUserName());
        boolean removeFlag = this.integralProductSkuService.update((Object)integralProductSkuPOUpdate, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(IntegralProductSkuPO::getIntegralProductCode, (Object)reqVO.getIntegralProductCode())).eq(IntegralProductSkuPO::getValid, (Object)Boolean.TRUE));
        Assert.isTrue((boolean)removeFlag, (String)"\u4fee\u6539\u5546\u54c1SKU\u5931\u8d25", (Object[])new Object[0]);
        List skuList = reqVO.getSkuList();
        List productSkuPOList = skuList.stream().map(skuReq -> {
            IntegralProductSkuPO skuPO = this.buildIntegralProductSkuPO(skuReq);
            skuPO.setIntegralProductCode(po.getIntegralProductCode());
            skuPO.setIntegralProductCode(reqVO.getIntegralProductCode());
            skuPO.setCreateUserCode(reqVO.getCreateUserCode());
            skuPO.setCreateUserName(reqVO.getCreateUserName());
            return skuPO;
        }).collect(Collectors.toList());
        boolean skuBatchSaveFlag = this.integralProductSkuService.saveBatch(productSkuPOList);
        Assert.isTrue((boolean)skuBatchSaveFlag, (String)"\u4fdd\u5b58\u5546\u54c1\u4fe1\u606f\u5931\u8d25", (Object[])new Object[0]);
        return new ResponseData((Object)skuBatchSaveFlag);
    }

    public ResponseData<Boolean> delete(IntegralProductDetailReq reqVO) {
        IntegralProductPO po = new IntegralProductPO();
        po.setValid(Boolean.valueOf(false));
        po.setModifiedUserCode(reqVO.getModifiedUserCode());
        po.setModifiedUserName(reqVO.getModifiedUserName());
        boolean updateFlag = this.integralProductService.update((Object)po, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(IntegralProductPO::getIntegralProductCode, (Object)reqVO.getIntegralProductCode())).eq(IntegralProductPO::getValid, (Object)Boolean.TRUE));
        return new ResponseData((Object)updateFlag);
    }

    public ResponseData<PageInfo<IntegralProductPageRes>> page(IntegralProductPageReq reqVO) {
        Page page = new Page((long)reqVO.getPageNum().intValue(), (long)reqVO.getPageSize().intValue());
        Page productPage = (Page)this.integralProductService.page((IPage)page, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(StringUtils.isNotBlank((CharSequence)reqVO.getProductNo()), IntegralProductPO::getProductNo, (Object)reqVO.getProductNo())).eq(StringUtils.isNotBlank((CharSequence)reqVO.getProductName()), IntegralProductPO::getProductName, (Object)reqVO.getProductName())).eq(StringUtils.isNotBlank((CharSequence)reqVO.getProductCategoryCode()), IntegralProductPO::getProductCategoryCode, (Object)reqVO.getProductCategoryCode())).eq(reqVO.getProductType() != null, IntegralProductPO::getProductType, (Object)reqVO.getProductType())).eq(reqVO.getState() != null, IntegralProductPO::getState, (Object)reqVO.getState())).eq(reqVO.getHotState() != null, IntegralProductPO::getHotState, (Object)reqVO.getHotState())).eq(IntegralProductPO::getValid, (Object)Boolean.TRUE));
        if (CollectionUtils.isEmpty((Collection)productPage.getRecords())) {
            return new ResponseData((Object)new PageInfo(0, 0, 0L, new ArrayList()));
        }
        productPage.getRecords().stream().map(po -> {
            IntegralProductPageRes pageRes = this.buildIntegralProductPageRes(po);
            if (IntegralMallProductTypeEnum.INTEGRAL_PRODUCT.getType().equals(po.getProductType())) {
                List list = this.integralProductSkuService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(IntegralProductSkuPO::getIntegralProductCode, (Object)po.getIntegralProductCode())).eq(IntegralProductSkuPO::getValid, (Object)Boolean.TRUE)).stream().map(skuPO -> {
                    IntegralProductSkuRes skuRes = this.buildIntegralProductSkuRes(skuPO);
                    return skuRes;
                }).collect(Collectors.toList());
            }
            return null;
        }).collect(Collectors.toList());
        return null;
    }

    @NotNull
    private IntegralProductSkuRes buildIntegralProductSkuRes(IntegralProductSkuPO skuPO) {
        IntegralProductSkuRes skuRes = new IntegralProductSkuRes();
        skuRes.setIntegralProductSkuCode(skuPO.getIntegralProductSkuCode());
        skuRes.setIntegralProductCode(skuPO.getIntegralProductCode());
        skuRes.setSpecNames(skuPO.getSpecNames());
        skuRes.setSpecCodes(skuPO.getSpecCodes());
        skuRes.setSpecDescription(skuPO.getSpecDescription());
        skuRes.setSkuNo(skuPO.getSkuNo());
        skuRes.setIntegralPrice(skuPO.getIntegralPrice());
        skuRes.setCashPrice(skuPO.getCashPrice());
        skuRes.setStockNum(skuPO.getStockNum());
        skuRes.setRemainNum(skuPO.getRemainNum());
        skuRes.setRealExchangeNum(skuPO.getRealExchangeNum());
        skuRes.setHoldOrderNum(skuPO.getHoldOrderNum());
        skuRes.setEnabled(skuPO.getEnabled());
        return skuRes;
    }

    private IntegralProductPageRes buildIntegralProductPageRes(IntegralProductPO po) {
        IntegralProductPageRes pageRes = new IntegralProductPageRes();
        pageRes.setIntegralProductCode(po.getIntegralProductCode());
        pageRes.setAirportNoOrg(po.getAirportNoOrg());
        pageRes.setProductCategoryCode(po.getProductCategoryCode());
        pageRes.setProductNo(po.getProductNo());
        pageRes.setProductName(po.getProductName());
        pageRes.setProductMainImg(po.getProductMainImg());
        pageRes.setPayType(po.getPayType());
        pageRes.setIntegralPrice(po.getIntegralPrice());
        pageRes.setCashPrice(po.getCashPrice());
        pageRes.setCostPrice(po.getCostPrice());
        pageRes.setCountPerLimit(po.getCountPerLimit());
        pageRes.setStockNum(po.getStockNum());
        pageRes.setVirtualExchangeNum(po.getVirtualExchangeNum());
        pageRes.setRemainNum(po.getRemainNum());
        pageRes.setRealExchangeNum(po.getRealExchangeNum());
        pageRes.setHoldOrderNum(po.getHoldOrderNum());
        pageRes.setMemberRangeType(po.getMemberRangeType());
        pageRes.setMemberLevelCode(po.getMemberLevelCode());
        pageRes.setSort(po.getSort());
        pageRes.setHotState(po.getHotState());
        pageRes.setProductType(po.getProductType());
        pageRes.setProductCouponType(po.getProductCouponType());
        pageRes.setProductCouponCode(po.getProductCouponCode());
        pageRes.setState(po.getState());
        pageRes.setUpFixedTime(po.getUpFixedTime());
        pageRes.setDownFixedTime(po.getDownFixedTime());
        return pageRes;
    }

    public ResponseData<IntegralProductDetailRes> get(String integralProductCode) {
        IntegralProductPO po = (IntegralProductPO)this.integralProductService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(IntegralProductPO::getIntegralProductCode, (Object)integralProductCode)).eq(IntegralProductPO::getValid, (Object)Boolean.TRUE));
        if (po == null) {
            return new ResponseData();
        }
        IntegralProductDetailRes detailRes = new IntegralProductDetailRes();
        detailRes.setIntegralProductCode(po.getIntegralProductCode());
        detailRes.setAirportNoOrg(po.getAirportNoOrg());
        detailRes.setProductCategoryCode(po.getProductCategoryCode());
        detailRes.setProductNo(po.getProductNo());
        detailRes.setProductName(po.getProductName());
        detailRes.setProductMainImg(po.getProductMainImg());
        detailRes.setPayType(po.getPayType());
        detailRes.setIntegralPrice(po.getIntegralPrice());
        detailRes.setCashPrice(po.getCashPrice());
        detailRes.setCostPrice(po.getCostPrice());
        detailRes.setCountPerLimit(po.getCountPerLimit());
        detailRes.setStockNum(po.getStockNum());
        detailRes.setVirtualExchangeNum(po.getVirtualExchangeNum());
        detailRes.setRemainNum(po.getRemainNum());
        detailRes.setRealExchangeNum(po.getRealExchangeNum());
        detailRes.setHoldOrderNum(po.getHoldOrderNum());
        detailRes.setMemberRangeType(po.getMemberRangeType());
        detailRes.setMemberLevelCode(po.getMemberLevelCode());
        detailRes.setSort(po.getSort());
        detailRes.setHotState(po.getHotState());
        detailRes.setProductType(po.getProductType());
        detailRes.setProductCouponType(po.getProductCouponType());
        detailRes.setProductCouponCode(po.getProductCouponCode());
        detailRes.setState(po.getState());
        detailRes.setCarouselImg(po.getCarouselImg());
        detailRes.setExchangeDesc(po.getExchangeDesc());
        detailRes.setUpFixedTime(po.getUpFixedTime());
        detailRes.setDownFixedTime(po.getDownFixedTime());
        detailRes.setProductDetailContent(po.getProductDetailContent());
        detailRes.setDeliveryType(po.getDeliveryType());
        detailRes.setDeliveryPriceType(po.getDeliveryPriceType());
        detailRes.setDeliveryPrice(po.getDeliveryPrice());
        if (IntegralMallProductTypeEnum.INTEGRAL_PRODUCT.getType().equals(po.getProductType())) {
            List skuResList = this.integralProductSkuService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(IntegralProductSkuPO::getIntegralProductCode, (Object)po.getIntegralProductCode())).eq(IntegralProductSkuPO::getValid, (Object)Boolean.TRUE)).stream().map(skuPO -> {
                IntegralProductSkuRes skuRes = this.buildIntegralProductSkuRes(skuPO);
                return skuRes;
            }).collect(Collectors.toList());
            detailRes.setSkuList(skuResList);
        }
        return new ResponseData((Object)detailRes);
    }

    public ResponseData<Boolean> upIntegralProductStatus(IntegralProductStatusReq reqVO) {
        boolean updateFlag = this.integralProductService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(IntegralProductPO::getState, (Object)reqVO.getState())).set(IntegralProductPO::getModifiedUserCode, (Object)reqVO.getModifiedUserCode())).set(IntegralProductPO::getModifiedUserName, (Object)reqVO.getModifiedUserName())).in(IntegralProductPO::getIntegralProductCode, (Collection)reqVO.getIntegralProductCodeList())).eq(IntegralProductPO::getValid, (Object)Boolean.TRUE));
        return new ResponseData((Object)updateFlag);
    }
}

