/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.airport.mall.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.airport.mall.api.bo.IntegralMallOrderPreparePayBO;
import com.bizvane.airport.mall.api.bo.PrepareOrderResBO;
import com.bizvane.airport.mall.api.service.IntegralMallOrderApiService;
import com.bizvane.airport.mall.api.service.OrderPayApiService;
import com.bizvane.airport.mall.domain.model.entity.IntegralMallOrderDetailPO;
import com.bizvane.airport.mall.domain.model.entity.IntegralMallOrderPO;
import com.bizvane.airport.mall.domain.model.entity.IntegralMallOrderStateRecordPO;
import com.bizvane.airport.mall.domain.model.entity.IntegralProductPO;
import com.bizvane.airport.mall.domain.model.entity.IntegralProductSkuPO;
import com.bizvane.airport.mall.domain.service.IntegralMallOrderDetailService;
import com.bizvane.airport.mall.domain.service.IntegralMallOrderService;
import com.bizvane.airport.mall.domain.service.IntegralMallOrderStateRecordService;
import com.bizvane.airport.mall.domain.service.IntegralProductService;
import com.bizvane.airport.mall.domain.service.IntegralProductSkuService;
import com.bizvane.airport.mall.feign.model.req.IntegralMallOrderAddReq;
import com.bizvane.airport.mall.feign.model.req.IntegralMallOrderCancelReq;
import com.bizvane.airport.mall.feign.model.req.IntegralMallOrderConfirmReceiptReq;
import com.bizvane.airport.mall.feign.model.req.IntegralMallOrderDeliveryReq;
import com.bizvane.airport.mall.feign.model.req.IntegralMallOrderOneReq;
import com.bizvane.airport.mall.feign.model.req.IntegralMallOrderPageReq;
import com.bizvane.airport.mall.feign.model.req.PrepareOrderReq;
import com.bizvane.airport.mall.feign.model.res.IntegralMallOrderDetailRes;
import com.bizvane.airport.mall.feign.model.res.IntegralMallOrderPageRes;
import com.bizvane.airport.mall.feign.model.res.IntegralMallOrderRes;
import com.bizvane.airport.mall.feign.model.res.PrepayWithRequestPaymentRes;
import com.bizvane.members.feign.model.vo.MbrLevelDefVO;
import com.bizvane.members.feign.model.vo.MbrMembersDetailVO;
import com.bizvane.members.feign.service.MbrLevelFeign;
import com.bizvane.members.feign.service.MbrMemberFeign;
import com.bizvane.payment.feign.api.ApiWechatPayFeign;
import com.bizvane.utils.enumutils.IntegralMallOrderStatusEnum;
import com.bizvane.utils.enumutils.IntegralMallProductTypeEnum;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class IntegralMallOrderApiServiceImpl
implements IntegralMallOrderApiService {
    @Autowired
    private IntegralMallOrderService integralMallOrderService;
    @Autowired
    private IntegralMallOrderDetailService integralMallOrderDetailService;
    @Autowired
    private IntegralProductService integralProductService;
    @Autowired
    private IntegralProductSkuService integralProductSkuService;
    @Autowired
    private MbrMemberFeign mbrMemberFeign;
    @Autowired
    private MbrLevelFeign mbrLevelFeign;
    @Autowired
    private ApiWechatPayFeign apiWechatPayFeign;
    @Autowired
    private OrderPayApiService orderPayApiService;
    @Autowired
    private IntegralMallOrderStateRecordService orderStateRecordService;

    public ResponseData<PrepayWithRequestPaymentRes> add(IntegralMallOrderAddReq reqVO) {
        ResponseData payBORes = null;
        if (IntegralMallProductTypeEnum.INTEGRAL_COUPON.getType().equals(reqVO.getProductType())) {
            payBORes = this.handleCouponOrder(reqVO);
        } else if (IntegralMallProductTypeEnum.INTEGRAL_PRODUCT.getType().equals(reqVO.getProductType())) {
            payBORes = this.handleGoodsOrder(reqVO);
        }
        if (payBORes == null) {
            return new ResponseData(SysResponseEnum.POINTS_REDEMPTION_FAILED.getCode(), SysResponseEnum.POINTS_REDEMPTION_FAILED.getMessage());
        }
        if (payBORes.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            return new ResponseData(payBORes.getCode(), payBORes.getMessage());
        }
        if (payBORes.getData() == null) {
            return new ResponseData(SysResponseEnum.POINTS_REDEMPTION_FAILED.getCode(), SysResponseEnum.POINTS_REDEMPTION_FAILED.getMessage());
        }
        ResponseData prepareOrderReqBORes = this.orderPayApiService.orderPrepay((IntegralMallOrderPreparePayBO)payBORes.getData());
        if (prepareOrderReqBORes.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            return new ResponseData(prepareOrderReqBORes.getCode(), prepareOrderReqBORes.getMessage());
        }
        PrepareOrderResBO prepareOrderResBO = (PrepareOrderResBO)prepareOrderReqBORes.getData();
        if (StringUtils.isNotBlank((CharSequence)prepareOrderResBO.getMbrIntegralRecordCode())) {
            boolean bl = this.integralMallOrderService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(IntegralMallOrderPO::getMbrIntegralRecordCode, (Object)prepareOrderResBO.getMbrIntegralRecordCode())).eq(IntegralMallOrderPO::getIntegralMallOrderCode, (Object)prepareOrderResBO.getIntegralMallOrderCode())).eq(IntegralMallOrderPO::getMbrMemberCode, (Object)prepareOrderResBO.getMbrMemberCode())).eq(IntegralMallOrderPO::getValid, (Object)Boolean.TRUE));
        }
        PrepayWithRequestPaymentRes prepayWithRequestPaymentRes = this.buildPrepayWithRequestPaymentRes(prepareOrderResBO);
        return new ResponseData(SysResponseEnum.SUCCESS.getCode(), SysResponseEnum.SUCCESS.getMessage(), (Object)prepayWithRequestPaymentRes);
    }

    @NotNull
    private PrepayWithRequestPaymentRes buildPrepayWithRequestPaymentRes(PrepareOrderResBO prepareOrderResBO) {
        PrepayWithRequestPaymentRes prepayWithRequestPaymentRes = new PrepayWithRequestPaymentRes();
        prepayWithRequestPaymentRes.setAppId(prepareOrderResBO.getAppId());
        prepareOrderResBO.setTimestamp(prepayWithRequestPaymentRes.getTimestamp());
        prepareOrderResBO.setNonceStr(prepayWithRequestPaymentRes.getNonceStr());
        prepareOrderResBO.setPackageVal(prepayWithRequestPaymentRes.getPackageVal());
        prepareOrderResBO.setSignType(prepayWithRequestPaymentRes.getSignType());
        prepareOrderResBO.setPaySign(prepayWithRequestPaymentRes.getPaySign());
        return prepayWithRequestPaymentRes;
    }

    public ResponseData<PageInfo<IntegralMallOrderPageRes>> page(IntegralMallOrderPageReq reqVO) {
        Page page = new Page((long)reqVO.getPageNum().intValue(), (long)reqVO.getPageSize().intValue());
        Page productPage = (Page)this.integralMallOrderService.page((IPage)page, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(StringUtils.isNotBlank((CharSequence)reqVO.getOrderNo()), IntegralMallOrderPO::getOrderNo, (Object)reqVO.getOrderNo())).eq(reqVO.getState() != null, IntegralMallOrderPO::getState, (Object)reqVO.getState())).eq(StringUtils.isNotBlank((CharSequence)reqVO.getMemberCode()), IntegralMallOrderPO::getMbrMemberCode, (Object)reqVO.getMemberCode())).eq(StringUtils.isNotBlank((CharSequence)reqVO.getMbrCardNo()), IntegralMallOrderPO::getMbrCardNo, (Object)reqVO.getMbrCardNo())).eq(StringUtils.isNotBlank((CharSequence)reqVO.getMbrPhone()), IntegralMallOrderPO::getMbrPhone, (Object)reqVO.getMbrPhone())).eq(reqVO.getPayType() != null, IntegralMallOrderPO::getPayType, (Object)reqVO.getPayType())).eq(StringUtils.isNotBlank((CharSequence)reqVO.getOrderProductNo()), IntegralMallOrderPO::getOrderProductNo, (Object)reqVO.getOrderProductNo())).eq(reqVO.getOrderProductName() != null, IntegralMallOrderPO::getOrderProductName, (Object)reqVO.getOrderProductName())).between(reqVO.getStartExchangeTime() != null && reqVO.getEndExchangeTime() != null, IntegralMallOrderPO::getExchangeTime, (Object)reqVO.getStartExchangeTime(), (Object)reqVO.getEndExchangeTime())).orderByDesc(IntegralMallOrderPO::getCreateDate)).eq(IntegralMallOrderPO::getValid, (Object)Boolean.TRUE));
        if (CollectionUtils.isEmpty((Collection)productPage.getRecords())) {
            return new ResponseData(SysResponseEnum.SUCCESS.getCode(), SysResponseEnum.SUCCESS.getMessage(), (Object)new PageInfo(0, 0, 0L, new ArrayList()));
        }
        List orderPageResList = productPage.getRecords().stream().map(po -> {
            IntegralMallOrderPageRes pageRes = this.buildIntegralMallOrderPageRes(po);
            return pageRes;
        }).collect(Collectors.toList());
        PageInfo pageInfo = new PageInfo(Long.valueOf(productPage.getCurrent()).intValue(), Long.valueOf(productPage.getSize()).intValue(), productPage.getTotal(), orderPageResList);
        return new ResponseData(SysResponseEnum.SUCCESS.getCode(), SysResponseEnum.SUCCESS.getMessage(), (Object)pageInfo);
    }

    private IntegralMallOrderPageRes buildIntegralMallOrderPageRes(IntegralMallOrderPO po) {
        IntegralMallOrderPageRes pageRes = new IntegralMallOrderPageRes();
        pageRes.setIntegralMallOrderCode(po.getIntegralMallOrderCode());
        pageRes.setOrderNo(po.getOrderNo());
        pageRes.setOrderType(po.getOrderType());
        pageRes.setMbrMemberCode(po.getMbrMemberCode());
        pageRes.setIntegralProductCode(po.getIntegralProductCode());
        pageRes.setOrderProductNo(po.getOrderProductNo());
        pageRes.setOrderProductName(po.getOrderProductName());
        pageRes.setExchangeNum(po.getExchangeNum());
        pageRes.setPayType(po.getPayType());
        pageRes.setPayIntegralAmount(po.getPayIntegralAmount());
        pageRes.setPayCashAmount(po.getPayCashAmount());
        pageRes.setExchangeTime(po.getExchangeTime());
        pageRes.setState(po.getState());
        pageRes.setMbrCardNo(po.getMbrCardNo());
        pageRes.setMbrName(po.getMbrName());
        pageRes.setMbrPhone(po.getMbrPhone());
        pageRes.setMbrLevelDefCode(po.getMbrLevelDefCode());
        pageRes.setMbrLevelDefName(po.getMbrLevelDefName());
        pageRes.setIntegralOrderTradeRecordCode(po.getIntegralOrderTradeRecordCode());
        pageRes.setTransactionId(po.getTransactionId());
        pageRes.setMbrIntegralRecordCode(po.getMbrIntegralRecordCode());
        return pageRes;
    }

    public ResponseData<Boolean> delivery(IntegralMallOrderDeliveryReq reqVO) {
        IntegralMallOrderPO po = new IntegralMallOrderPO();
        po.setCourierCompanyName(reqVO.getCourierCompanyName());
        po.setCourierCompanyCode(reqVO.getCourierCompanyCode());
        po.setCourierNo(reqVO.getCourierNo());
        po.setDeliveryDate(LocalDateTime.now());
        po.setModifiedUserCode(reqVO.getModifiedUserCode());
        po.setModifiedUserName(reqVO.getModifiedUserName());
        boolean updateFlag = this.integralMallOrderService.update((Object)po, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(IntegralMallOrderPO::getIntegralMallOrderCode, (Object)reqVO.getIntegralMallOrderCode())).eq(IntegralMallOrderPO::getState, (Object)IntegralMallOrderStatusEnum.WAIT_DELIVERY.getType())).eq(IntegralMallOrderPO::getValid, (Object)Boolean.TRUE));
        return new ResponseData(updateFlag ? SysResponseEnum.SUCCESS.getCode() : SysResponseEnum.FAILED.getCode(), updateFlag ? SysResponseEnum.SUCCESS.getMessage() : SysResponseEnum.FAILED.getMessage(), (Object)updateFlag);
    }

    public ResponseData<PrepayWithRequestPaymentRes> prepay(PrepareOrderReq reqVO) {
        IntegralMallOrderPO orderPO = (IntegralMallOrderPO)this.integralMallOrderService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(IntegralMallOrderPO::getIntegralMallOrderCode, (Object)reqVO.getIntegralMallOrderCode())).eq(IntegralMallOrderPO::getMbrMemberCode, (Object)reqVO.getMbrMemberCode())).eq(IntegralMallOrderPO::getState, (Object)IntegralMallOrderStatusEnum.WAIT_PAY.getType())).eq(IntegralMallOrderPO::getValid, (Object)Boolean.TRUE));
        if (orderPO == null) {
            return new ResponseData(SysResponseEnum.POINTS_MALL_ORDER_NOT_FOUND.getCode(), SysResponseEnum.POINTS_MALL_ORDER_NOT_FOUND.getMessage());
        }
        IntegralMallOrderPreparePayBO payBO = new IntegralMallOrderPreparePayBO();
        payBO.setIntegralMallOrderCode(orderPO.getIntegralMallOrderCode());
        payBO.setOrderNo(orderPO.getOrderNo());
        payBO.setMbrMemberCode(orderPO.getMbrMemberCode());
        payBO.setMbrOpenid(orderPO.getMbrOpenid());
        payBO.setProductType(orderPO.getOrderType());
        payBO.setOrderProductNo(orderPO.getOrderProductNo());
        payBO.setOrderProductName(orderPO.getOrderProductName());
        payBO.setPayType(orderPO.getPayType());
        payBO.setPayIntegralAmount(Integer.valueOf(StringUtils.isBlank((CharSequence)orderPO.getMbrIntegralRecordCode()) ? orderPO.getPayIntegralAmount() : 0));
        payBO.setPayCashAmount(orderPO.getPayCashAmount());
        ResponseData prepareOrderReqBORes = this.orderPayApiService.orderPrepay(payBO);
        Assert.isTrue((prepareOrderReqBORes.getCode() == SysResponseEnum.SUCCESS.getCode() ? 1 : 0) != 0, (String)prepareOrderReqBORes.getMessage());
        PrepareOrderResBO prepareOrderResBO = (PrepareOrderResBO)prepareOrderReqBORes.getData();
        if (StringUtils.isNotBlank((CharSequence)prepareOrderResBO.getMbrIntegralRecordCode())) {
            boolean bl = this.integralMallOrderService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(IntegralMallOrderPO::getMbrIntegralRecordCode, (Object)prepareOrderResBO.getMbrIntegralRecordCode())).eq(IntegralMallOrderPO::getIntegralMallOrderCode, (Object)prepareOrderResBO.getIntegralMallOrderCode())).eq(IntegralMallOrderPO::getMbrMemberCode, (Object)prepareOrderResBO.getMbrMemberCode())).eq(IntegralMallOrderPO::getValid, (Object)Boolean.TRUE));
        }
        PrepayWithRequestPaymentRes prepayWithRequestPaymentRes = this.buildPrepayWithRequestPaymentRes(prepareOrderResBO);
        return new ResponseData((Object)prepayWithRequestPaymentRes);
    }

    public ResponseData<Boolean> cancel(IntegralMallOrderCancelReq reqVO) {
        IntegralMallOrderPO orderPO = (IntegralMallOrderPO)this.integralMallOrderService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(IntegralMallOrderPO::getIntegralMallOrderCode, (Object)reqVO.getIntegralMallOrderCode())).eq(IntegralMallOrderPO::getMbrMemberCode, (Object)reqVO.getMbrMemberCode())).eq(IntegralMallOrderPO::getState, (Object)IntegralMallOrderStatusEnum.WAIT_PAY.getType())).eq(IntegralMallOrderPO::getValid, (Object)Boolean.TRUE));
        if (orderPO == null) {
            return new ResponseData(SysResponseEnum.POINTS_MALL_ORDER_CANCEL_NOT_ALLOWED.getCode(), SysResponseEnum.POINTS_MALL_ORDER_CANCEL_NOT_ALLOWED.getMessage(), (Object)false);
        }
        boolean updateFlag = this.integralMallOrderService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(IntegralMallOrderPO::getState, (Object)IntegralMallOrderStatusEnum.CLOSE.getType())).set(IntegralMallOrderPO::getModifiedUserCode, (Object)reqVO.getModifiedUserCode())).set(IntegralMallOrderPO::getModifiedUserName, (Object)reqVO.getModifiedUserName())).eq(IntegralMallOrderPO::getIntegralMallOrderCode, (Object)reqVO.getIntegralMallOrderCode())).eq(IntegralMallOrderPO::getMbrMemberCode, (Object)reqVO.getMbrMemberCode())).eq(IntegralMallOrderPO::getState, (Object)IntegralMallOrderStatusEnum.WAIT_PAY.getType())).eq(IntegralMallOrderPO::getValid, (Object)Boolean.TRUE));
        if (!updateFlag) {
            return new ResponseData(SysResponseEnum.POINTS_MALL_ORDER_CANCEL_FAILED.getCode(), SysResponseEnum.POINTS_MALL_ORDER_CANCEL_FAILED.getMessage(), (Object)false);
        }
        IntegralMallOrderStateRecordPO orderStateRecordPO = new IntegralMallOrderStateRecordPO();
        orderStateRecordPO.setIntegralMallOrderCode(orderPO.getIntegralMallOrderCode());
        orderStateRecordPO.setOperationType(reqVO.getCancelType());
        orderStateRecordPO.setOperationDesc(reqVO.getCancelReason());
        orderStateRecordPO.setState(IntegralMallOrderStatusEnum.CLOSE.getType());
        orderStateRecordPO.setCreateUserCode(reqVO.getModifiedUserCode());
        orderStateRecordPO.setCreateUserName(reqVO.getModifiedUserName());
        this.orderStateRecordService.save((Object)orderStateRecordPO);
        return new ResponseData((Object)true);
    }

    public ResponseData<Boolean> confirmReceipt(IntegralMallOrderConfirmReceiptReq reqVO) {
        IntegralMallOrderPO orderPO = (IntegralMallOrderPO)this.integralMallOrderService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(IntegralMallOrderPO::getIntegralMallOrderCode, (Object)reqVO.getIntegralMallOrderCode())).eq(IntegralMallOrderPO::getMbrMemberCode, (Object)reqVO.getMbrMemberCode())).eq(IntegralMallOrderPO::getState, (Object)IntegralMallOrderStatusEnum.DELIVERY.getType())).eq(IntegralMallOrderPO::getValid, (Object)Boolean.TRUE));
        if (orderPO == null) {
            return new ResponseData(SysResponseEnum.POINTS_MALL_ORDER_CANCEL_NOT_ALLOWED.getCode(), SysResponseEnum.POINTS_MALL_ORDER_CANCEL_NOT_ALLOWED.getMessage(), (Object)false);
        }
        boolean updateFlag = this.integralMallOrderService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(IntegralMallOrderPO::getState, (Object)IntegralMallOrderStatusEnum.SIGN.getType())).set(IntegralMallOrderPO::getModifiedUserCode, (Object)reqVO.getModifiedUserCode())).set(IntegralMallOrderPO::getModifiedUserName, (Object)reqVO.getModifiedUserName())).eq(IntegralMallOrderPO::getIntegralMallOrderCode, (Object)reqVO.getIntegralMallOrderCode())).eq(IntegralMallOrderPO::getMbrMemberCode, (Object)reqVO.getMbrMemberCode())).eq(IntegralMallOrderPO::getState, (Object)IntegralMallOrderStatusEnum.DELIVERY.getType())).eq(IntegralMallOrderPO::getValid, (Object)Boolean.TRUE));
        if (!updateFlag) {
            return new ResponseData(SysResponseEnum.OPERATE_FAILED_UPDATE_ERROR.getCode(), SysResponseEnum.OPERATE_FAILED_UPDATE_ERROR.getMessage(), (Object)false);
        }
        IntegralMallOrderStateRecordPO orderStateRecordPO = new IntegralMallOrderStateRecordPO();
        orderStateRecordPO.setIntegralMallOrderCode(orderPO.getIntegralMallOrderCode());
        orderStateRecordPO.setOperationType(reqVO.getConfirmReceiptType());
        orderStateRecordPO.setState(IntegralMallOrderStatusEnum.SIGN.getType());
        orderStateRecordPO.setCreateUserCode(reqVO.getModifiedUserCode());
        orderStateRecordPO.setCreateUserName(reqVO.getModifiedUserName());
        this.orderStateRecordService.save((Object)orderStateRecordPO);
        return new ResponseData((Object)true);
    }

    public ResponseData<IntegralMallOrderRes> detail(IntegralMallOrderOneReq reqVO) {
        IntegralMallOrderPO orderPO = (IntegralMallOrderPO)this.integralMallOrderService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(IntegralMallOrderPO::getIntegralMallOrderCode, (Object)reqVO.getIntegralMallOrderCode())).eq(IntegralMallOrderPO::getMbrMemberCode, (Object)reqVO.getMbrMemberCode())).eq(IntegralMallOrderPO::getValid, (Object)Boolean.TRUE));
        if (orderPO == null) {
            return new ResponseData(SysResponseEnum.POINTS_MALL_ORDER_NOT_FOUND.getCode(), SysResponseEnum.POINTS_MALL_ORDER_NOT_FOUND.getMessage(), null);
        }
        IntegralMallOrderRes res = this.buildIntegralMallOrderRes(orderPO);
        if (IntegralMallProductTypeEnum.INTEGRAL_COUPON.getType().equals(orderPO.getOrderType())) {
            return new ResponseData((Object)res);
        }
        List orderDetailPOList = this.integralMallOrderDetailService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(IntegralMallOrderDetailPO::getIntegralMallOrderCode, (Object)reqVO.getIntegralMallOrderCode())).eq(IntegralMallOrderDetailPO::getValid, (Object)Boolean.TRUE));
        if (CollectionUtils.isEmpty((Collection)orderDetailPOList)) {
            return new ResponseData(SysResponseEnum.POINTS_MALL_ORDER_NOT_FOUND.getCode(), SysResponseEnum.POINTS_MALL_ORDER_NOT_FOUND.getMessage(), null);
        }
        List orderDetailResList = orderDetailPOList.stream().map(detailPO -> this.buildIntegralMallOrderDetailRes(detailPO)).collect(Collectors.toList());
        res.setOrderDetailList(orderDetailResList);
        return new ResponseData((Object)res);
    }

    @NotNull
    private IntegralMallOrderRes buildIntegralMallOrderRes(IntegralMallOrderPO orderPO) {
        IntegralMallOrderRes res = new IntegralMallOrderRes();
        res.setIntegralMallOrderCode(orderPO.getIntegralMallOrderCode());
        res.setOrderNo(orderPO.getOrderNo());
        res.setOrderType(orderPO.getOrderType());
        res.setMbrMemberCode(orderPO.getMbrMemberCode());
        res.setIntegralProductCode(orderPO.getIntegralProductCode());
        res.setOrderProductNo(orderPO.getOrderProductNo());
        res.setOrderProductName(orderPO.getOrderProductName());
        res.setExchangeNum(orderPO.getExchangeNum());
        res.setPayType(orderPO.getPayType());
        res.setPayIntegralAmount(orderPO.getPayIntegralAmount());
        res.setPayCashAmount(orderPO.getPayCashAmount());
        res.setExchangeTime(orderPO.getExchangeTime());
        res.setState(orderPO.getState());
        res.setMbrCardNo(orderPO.getMbrCardNo());
        res.setMbrName(orderPO.getMbrName());
        res.setMbrPhone(orderPO.getMbrPhone());
        res.setMbrLevelDefCode(orderPO.getMbrLevelDefCode());
        res.setMbrLevelDefName(orderPO.getMbrLevelDefName());
        res.setIntegralOrderTradeRecordCode(orderPO.getIntegralOrderTradeRecordCode());
        res.setTransactionId(orderPO.getTransactionId());
        res.setMbrIntegralRecordCode(orderPO.getMbrIntegralRecordCode());
        res.setDeliveryType(orderPO.getDeliveryType());
        res.setDeliveryDate(orderPO.getDeliveryDate());
        res.setConsigneeName(orderPO.getConsigneeName());
        res.setConsigneeMobile(orderPO.getConsigneeMobile());
        res.setConsigneeProvince(orderPO.getConsigneeProvince());
        res.setConsigneeCity(orderPO.getConsigneeCity());
        res.setConsigneeDistrict(orderPO.getConsigneeDistrict());
        res.setConsigneeAddress(orderPO.getConsigneeAddress());
        res.setUserComments(orderPO.getUserComments());
        res.setCourierCompanyName(orderPO.getCourierCompanyName());
        res.setCourierCompanyCode(orderPO.getCourierCompanyCode());
        res.setCourierNo(orderPO.getCourierNo());
        res.setReceiveDate(orderPO.getReceiveDate());
        return res;
    }

    @NotNull
    private IntegralMallOrderDetailRes buildIntegralMallOrderDetailRes(IntegralMallOrderDetailPO detailPO) {
        IntegralMallOrderDetailRes detailRes = new IntegralMallOrderDetailRes();
        detailRes.setIntegralMallOrderDetailCode(detailPO.getIntegralMallOrderDetailCode());
        detailRes.setIntegralMallOrderCode(detailPO.getIntegralMallOrderCode());
        detailRes.setOrderNo(detailPO.getOrderNo());
        detailRes.setIntegralProductCode(detailPO.getIntegralProductCode());
        detailRes.setIntegralProductSkuCode(detailPO.getIntegralProductSkuCode());
        detailRes.setProductSkuNo(detailPO.getProductSkuNo());
        detailRes.setProductSkuImg(detailPO.getProductSkuImg());
        detailRes.setProductSkuSpecNames(detailPO.getProductSkuSpecNames());
        detailRes.setProductSkuSpecCodes(detailPO.getProductSkuSpecCodes());
        detailRes.setProductSkuSpecDescription(detailPO.getProductSkuSpecDescription());
        detailRes.setProductIntegralPrice(detailPO.getProductIntegralPrice());
        detailRes.setProductCashPrice(detailPO.getProductCashPrice());
        detailRes.setSaleQuantity(detailPO.getSaleQuantity());
        return detailRes;
    }

    private ResponseData<IntegralMallOrderPreparePayBO> handleCouponOrder(IntegralMallOrderAddReq reqVO) {
        IntegralProductPO productPO = (IntegralProductPO)this.integralProductService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(IntegralProductPO::getIntegralProductCode, (Object)reqVO.getIntegralProductCode())).eq(IntegralProductPO::getValid, (Object)Boolean.TRUE));
        if (productPO == null) {
            return new ResponseData(SysResponseEnum.PRODUCT_NOT_FOUND.getCode(), SysResponseEnum.PRODUCT_NOT_FOUND.getMessage(), (Object)false);
        }
        if (productPO.getStockNum() < reqVO.getExchangeNum()) {
            return new ResponseData(SysResponseEnum.INSUFFICIENT_STOCK.getCode(), SysResponseEnum.INSUFFICIENT_STOCK.getMessage(), (Object)false);
        }
        boolean updateStockFlag = this.integralProductService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().setSql("remainNum = remainNum - #{exchangeNum}, realExchangeNum = realExchangeNum + #{exchangeNum}, hold_order_num = hold_order_num + #{holdOrderNum}", new Object[]{reqVO.getExchangeNum()})).eq(IntegralProductPO::getIntegralProductCode, (Object)reqVO.getIntegralProductCode())).ge(IntegralProductPO::getRemainNum, (Object)reqVO.getExchangeNum())).eq(IntegralProductPO::getValid, (Object)Boolean.TRUE));
        if (!updateStockFlag) {
            return new ResponseData(SysResponseEnum.INSUFFICIENT_STOCK.getCode(), SysResponseEnum.INSUFFICIENT_STOCK.getMessage(), (Object)false);
        }
        ResponseData membersDetailVOResponseData = this.mbrMemberFeign.detail(reqVO.getMbrMemberCode());
        Assert.isTrue((membersDetailVOResponseData.getCode() == SysResponseEnum.SUCCESS.getCode() && membersDetailVOResponseData.getData() != null ? 1 : 0) != 0, (String)"\u4f1a\u5458\u4fe1\u606f\u4e0d\u5b58\u5728");
        MbrMembersDetailVO membersDetailVO = (MbrMembersDetailVO)membersDetailVOResponseData.getData();
        MbrLevelDefVO mbrLevelDefVO = this.mbrLevelFeign.defDetail(membersDetailVO.getMbrLevelDefCode());
        Assert.isTrue((mbrLevelDefVO != null ? 1 : 0) != 0, (String)"\u4f1a\u5458\u7b49\u7ea7\u4e0d\u5b58\u5728");
        IntegralMallOrderPO orderPO = this.buildIntegralMallOrderPO(reqVO, productPO, membersDetailVO, mbrLevelDefVO);
        boolean orderSaveFlag = this.integralMallOrderService.save((Object)orderPO);
        Assert.isTrue((boolean)orderSaveFlag, (String)"\u8ba2\u5355\u4fdd\u5b58\u5931\u8d25");
        IntegralMallOrderPreparePayBO preparePayBO = this.buildIntegralMallOrderPreparePayBO(orderPO);
        return new ResponseData((Object)preparePayBO);
    }

    @NotNull
    private IntegralMallOrderPreparePayBO buildIntegralMallOrderPreparePayBO(IntegralMallOrderPO orderPO) {
        IntegralMallOrderPreparePayBO preparePayBO = new IntegralMallOrderPreparePayBO();
        preparePayBO.setIntegralMallOrderCode(orderPO.getIntegralMallOrderCode());
        preparePayBO.setOrderNo(orderPO.getOrderNo());
        preparePayBO.setMbrMemberCode(orderPO.getMbrMemberCode());
        preparePayBO.setMbrOpenid(orderPO.getMbrOpenid());
        preparePayBO.setProductType(orderPO.getOrderType());
        preparePayBO.setOrderProductNo(orderPO.getOrderProductNo());
        preparePayBO.setOrderProductName(orderPO.getOrderProductName());
        preparePayBO.setPayType(orderPO.getPayType());
        preparePayBO.setPayIntegralAmount(orderPO.getPayIntegralAmount());
        preparePayBO.setPayCashAmount(orderPO.getPayCashAmount());
        return preparePayBO;
    }

    @NotNull
    private IntegralMallOrderPO buildIntegralMallOrderPO(IntegralMallOrderAddReq reqVO, IntegralProductPO productPO, MbrMembersDetailVO membersDetailVO, MbrLevelDefVO mbrLevelDefVO) {
        IntegralMallOrderPO orderPO = new IntegralMallOrderPO();
        orderPO.setOrderNo("1233");
        orderPO.setMbrMemberCode(membersDetailVO.getMbrMembersCode());
        orderPO.setMbrOpenid(reqVO.getMbrOpenid());
        orderPO.setMbrCardNo(membersDetailVO.getCardNo());
        orderPO.setMbrName(membersDetailVO.getName());
        orderPO.setMbrPhone(membersDetailVO.getPhone());
        orderPO.setMbrLevelDefCode(membersDetailVO.getMbrLevelDefCode());
        orderPO.setMbrLevelDefName(mbrLevelDefVO.getLevelName());
        orderPO.setOrderType(reqVO.getProductType());
        orderPO.setIntegralProductCode(reqVO.getIntegralProductCode());
        orderPO.setOrderProductNo(productPO.getProductCouponCode());
        orderPO.setOrderProductName(productPO.getProductName());
        orderPO.setExchangeNum(reqVO.getExchangeNum());
        orderPO.setPayType(productPO.getPayType());
        orderPO.setPayIntegralAmount(Integer.valueOf(productPO.getIntegralPrice() * reqVO.getExchangeNum()));
        orderPO.setPayCashAmount(productPO.getCashPrice().multiply(new BigDecimal(reqVO.getExchangeNum())));
        orderPO.setExchangeTime(LocalDateTime.now());
        orderPO.setState(IntegralMallOrderStatusEnum.WAIT_PAY.getType());
        orderPO.setDeliveryType(reqVO.getDeliveryType());
        orderPO.setConsigneeName(reqVO.getConsigneeName());
        orderPO.setConsigneeMobile(reqVO.getConsigneeMobile());
        orderPO.setConsigneeProvince(reqVO.getConsigneeProvince());
        orderPO.setConsigneeCity(reqVO.getConsigneeCity());
        orderPO.setConsigneeDistrict(reqVO.getConsigneeDistrict());
        orderPO.setConsigneeAddress(reqVO.getConsigneeAddress());
        orderPO.setUserComments(reqVO.getUserComments());
        return orderPO;
    }

    private ResponseData<IntegralMallOrderPreparePayBO> handleGoodsOrder(IntegralMallOrderAddReq reqVO) {
        IntegralProductPO productPO = (IntegralProductPO)this.integralProductService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(IntegralProductPO::getIntegralProductCode, (Object)reqVO.getIntegralProductCode())).eq(IntegralProductPO::getValid, (Object)Boolean.TRUE));
        if (productPO == null) {
            return new ResponseData(SysResponseEnum.PRODUCT_NOT_FOUND.getCode(), SysResponseEnum.PRODUCT_NOT_FOUND.getMessage(), (Object)false);
        }
        IntegralProductSkuPO productSkuPO = (IntegralProductSkuPO)this.integralProductSkuService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(IntegralProductSkuPO::getIntegralProductSkuCode, (Object)reqVO.getIntegralProductSkuCode())).eq(IntegralProductSkuPO::getValid, (Object)Boolean.TRUE));
        if (productSkuPO == null) {
            return new ResponseData(SysResponseEnum.PRODUCT_NOT_FOUND.getCode(), SysResponseEnum.PRODUCT_NOT_FOUND.getMessage(), (Object)false);
        }
        if (productSkuPO.getStockNum() < reqVO.getExchangeNum()) {
            return new ResponseData(SysResponseEnum.INSUFFICIENT_STOCK.getCode(), SysResponseEnum.INSUFFICIENT_STOCK.getMessage(), (Object)false);
        }
        boolean updateStockFlag = this.integralProductSkuService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().setSql("remainNum = remainNum - #{exchangeNum}, realExchangeNum = realExchangeNum + #{exchangeNum}, hold_order_num = hold_order_num + #{holdOrderNum}", new Object[]{reqVO.getExchangeNum()})).eq(IntegralProductSkuPO::getIntegralProductCode, (Object)reqVO.getIntegralProductCode())).ge(IntegralProductSkuPO::getRemainNum, (Object)reqVO.getExchangeNum())).eq(IntegralProductSkuPO::getValid, (Object)Boolean.TRUE));
        if (!updateStockFlag) {
            return new ResponseData(SysResponseEnum.INSUFFICIENT_STOCK.getCode(), SysResponseEnum.INSUFFICIENT_STOCK.getMessage(), (Object)false);
        }
        this.integralProductService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().setSql("remainNum = remainNum - #{exchangeNum}, realExchangeNum = realExchangeNum + #{exchangeNum}, hold_order_num = hold_order_num + #{holdOrderNum}", new Object[]{reqVO.getExchangeNum()})).eq(IntegralProductPO::getIntegralProductCode, (Object)reqVO.getIntegralProductCode())).eq(IntegralProductPO::getValid, (Object)Boolean.TRUE));
        ResponseData membersDetailVOResponseData = this.mbrMemberFeign.detail(reqVO.getMbrMemberCode());
        Assert.isTrue((membersDetailVOResponseData.getCode() == SysResponseEnum.SUCCESS.getCode() && membersDetailVOResponseData.getData() != null ? 1 : 0) != 0, (String)"\u4f1a\u5458\u4fe1\u606f\u4e0d\u5b58\u5728");
        MbrMembersDetailVO membersDetailVO = (MbrMembersDetailVO)membersDetailVOResponseData.getData();
        MbrLevelDefVO mbrLevelDefVO = this.mbrLevelFeign.defDetail(membersDetailVO.getMbrLevelDefCode());
        Assert.isTrue((mbrLevelDefVO != null ? 1 : 0) != 0, (String)"\u4f1a\u5458\u7b49\u7ea7\u4e0d\u5b58\u5728");
        IntegralMallOrderPO orderPO = this.buildIntegralMallOrderPO(reqVO, productPO, membersDetailVO, mbrLevelDefVO);
        boolean orderSaveFlag = this.integralMallOrderService.save((Object)orderPO);
        Assert.isTrue((boolean)orderSaveFlag, (String)"\u8ba2\u5355\u4fdd\u5b58\u5931\u8d25");
        IntegralMallOrderDetailPO orderDetailPO = this.buildIntegralMallOrderDetailPO(reqVO, productPO, productSkuPO, orderPO);
        boolean orderDetailSaveFlag = this.integralMallOrderDetailService.save((Object)orderDetailPO);
        Assert.isTrue((boolean)orderDetailSaveFlag, (String)"\u8ba2\u5355\u660e\u7ec6\u4fdd\u5b58\u5931\u8d25");
        IntegralMallOrderPreparePayBO preparePayBO = this.buildIntegralMallOrderPreparePayBO(orderPO);
        return new ResponseData((Object)preparePayBO);
    }

    @NotNull
    private IntegralMallOrderDetailPO buildIntegralMallOrderDetailPO(IntegralMallOrderAddReq reqVO, IntegralProductPO productPO, IntegralProductSkuPO productSkuPO, IntegralMallOrderPO orderPO) {
        IntegralMallOrderDetailPO orderDetailPO = new IntegralMallOrderDetailPO();
        orderDetailPO.setIntegralMallOrderCode(orderPO.getIntegralMallOrderCode());
        orderDetailPO.setOrderNo(orderPO.getOrderNo());
        orderDetailPO.setIntegralProductCode(productSkuPO.getIntegralProductCode());
        orderDetailPO.setIntegralProductSkuCode(productSkuPO.getIntegralProductSkuCode());
        orderDetailPO.setProductSkuNo(productSkuPO.getSkuNo());
        orderDetailPO.setProductSkuImg(productPO.getProductMainImg());
        orderDetailPO.setProductSkuSpecNames(productSkuPO.getSpecNames());
        orderDetailPO.setProductSkuSpecCodes(productSkuPO.getSpecCodes());
        orderDetailPO.setProductSkuSpecDescription(productSkuPO.getSpecDescription());
        orderDetailPO.setProductIntegralPrice(productSkuPO.getIntegralPrice());
        orderDetailPO.setProductCashPrice(productSkuPO.getCashPrice());
        orderDetailPO.setSaleQuantity(reqVO.getExchangeNum());
        return orderDetailPO;
    }
}

