/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.airport.mall.api.service.jobhandler;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.bizvane.airport.mall.api.service.MQIntegralMallOrderService;
import com.bizvane.airport.mall.domain.domain.po.TIntegralMallOrder;
import com.bizvane.airport.mall.domain.service.TIntegralMallOrderService;
import com.bizvane.payment.feign.api.ApiWechatPayFeign;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import com.wechat.pay.java.service.payments.model.Transaction;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PendingPayOrderJobHandler {
    private static final Logger log = LoggerFactory.getLogger(PendingPayOrderJobHandler.class);
    @Autowired
    private TIntegralMallOrderService tIntegralMallOrderService;
    @Autowired
    private ApiWechatPayFeign apiWechatPayFeign;
    @Autowired
    private MQIntegralMallOrderService mqIntegralMallOrderService;

    @XxlJob(value="pendingPayOrderJobHandler")
    public ReturnT<String> execute(String param) throws Exception {
        LocalDateTime thirtyMinAgo = DateUtil.date().toLocalDateTime().minusMinutes(30L);
        DateTime thirtyMinAgoDate = DateUtil.date((TemporalAccessor)thirtyMinAgo);
        List orderList = this.tIntegralMallOrderService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TIntegralMallOrder::getState, (Object)0)).eq(TIntegralMallOrder::getValid, (Object)1)).le(TIntegralMallOrder::getExchangeTime, (Object)thirtyMinAgoDate));
        log.info("\u5f85\u652f\u4ed8\u8ba2\u5355\u5217\u8868: {}", (Object)JacksonUtil.list2Json((List)orderList));
        if (CollUtil.isNotEmpty((Collection)orderList)) {
            for (TIntegralMallOrder order : orderList) {
                ResponseData paidRespData = this.apiWechatPayFeign.queryOrder(order.getIntegralMallOrderCode());
                log.info("paidRespData: {}", (Object)JacksonUtil.bean2Json((Object)paidRespData));
                Transaction transaction = (Transaction)paidRespData.getData();
                if (StrUtil.equals((CharSequence)transaction.getTradeState().name(), (CharSequence)Transaction.TradeStateEnum.NOTPAY.name())) {
                    ResponseData closeOrderResp = this.apiWechatPayFeign.closeOrder(order.getIntegralMallOrderCode());
                    log.info("closeOrderResp: {}", (Object)JacksonUtil.bean2Json((Object)closeOrderResp));
                    boolean update = this.tIntegralMallOrderService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TIntegralMallOrder::getIntegralMallOrderCode, (Object)order.getIntegralMallOrderCode())).eq(TIntegralMallOrder::getState, (Object)0)).eq(TIntegralMallOrder::getValid, (Object)1)).set(TIntegralMallOrder::getState, (Object)6));
                    log.info("closeOrderResp update: {}", (Object)update);
                    continue;
                }
                this.mqIntegralMallOrderService.wechatPayProcess(transaction);
            }
        }
        return ReturnT.SUCCESS;
    }
}

