/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.airport.mall.api.service.impl.mobile;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.airport.mall.api.controller.req.AddIntegralMallOrderReqVO;
import com.bizvane.airport.mall.api.controller.req.MobileOrderPageReqVO;
import com.bizvane.airport.mall.api.controller.resp.MobileOrderDetailRespVO;
import com.bizvane.airport.mall.api.controller.resp.MobileOrderPageRespVO;
import com.bizvane.airport.mall.api.login.LoginInfoUtil;
import com.bizvane.airport.mall.api.login.MemberLoginBO;
import com.bizvane.airport.mall.api.service.MobileOrderService;
import com.bizvane.airport.mall.api.utils.CommonUtil;
import com.bizvane.airport.mall.api.utils.ResponseUtil;
import com.bizvane.airport.mall.domain.config.WechatPayProperties;
import com.bizvane.airport.mall.domain.domain.po.TIntegralMallOrder;
import com.bizvane.airport.mall.domain.domain.po.TIntegralProduct;
import com.bizvane.airport.mall.domain.service.TIntegralMallOrderService;
import com.bizvane.airport.mall.domain.service.TIntegralProductService;
import com.bizvane.payment.feign.api.ApiWechatPayFeign;
import com.bizvane.payment.feign.vo.req.PrepareOrderReqVO;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MobileOrderServiceImpl
implements MobileOrderService {
    private static final Logger log = LoggerFactory.getLogger(MobileOrderServiceImpl.class);
    @Autowired
    private TIntegralMallOrderService integralMallOrderService;
    @Autowired
    private TIntegralProductService tIntegralProductService;
    @Autowired
    private WechatPayProperties wechatPayProperties;
    @Autowired
    private ApiWechatPayFeign apiWechatPayFeign;

    public ResponseData<String> createOrder(AddIntegralMallOrderReqVO reqVO) {
        Integer exchangeNum = reqVO.getExchangeNum();
        TIntegralProduct integralProduct = (TIntegralProduct)this.tIntegralProductService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TIntegralProduct::getIntegralProductCode, (Object)reqVO.getIntegralProductCode())).eq(TIntegralProduct::getValid, (Object)1));
        if (integralProduct == null) {
            return ResponseUtil.getFailedMsg((String)"\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if (exchangeNum > integralProduct.getRemainNum()) {
            return ResponseUtil.getFailedMsg((String)"\u5e93\u5b58\u4e0d\u8db3");
        }
        if (ObjUtil.equals((Object)integralProduct.getMemberRangeType(), (Object)2)) {
            // empty if block
        }
        TIntegralMallOrder order = new TIntegralMallOrder();
        order.setState(Integer.valueOf(0));
        order.setOrderNo(CommonUtil.getOrderNo());
        order.setIntegralMallOrderCode(IdUtil.fastSimpleUUID());
        order.setMbrMemberCode(reqVO.getMbrMemberCode());
        order.setIntegralProductCode(integralProduct.getIntegralProductCode());
        order.setPayType(integralProduct.getPayType());
        order.setExchangeNum(exchangeNum);
        order.setPayIntegralAmount(Integer.valueOf(integralProduct.getIntegralPrice() * exchangeNum));
        order.setPayCashAmount(Integer.valueOf(integralProduct.getCashPrice() * exchangeNum));
        order.setExchangeTime(new Date());
        order.setDeliveryType(reqVO.getDeliveryType());
        order.setConsigneeName(reqVO.getConsigneeName());
        order.setConsigneeMobile(reqVO.getConsigneeMobile());
        order.setConsigneeProvince(reqVO.getConsigneeProvince());
        order.setConsigneeCity(reqVO.getConsigneeCity());
        order.setConsigneeDistrict(reqVO.getConsigneeDistrict());
        order.setConsigneeAddress(reqVO.getConsigneeAddress());
        order.setUserComments(reqVO.getUserComments());
        order.setValid(Integer.valueOf(1));
        boolean update = this.tIntegralProductService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TIntegralProduct::getId, (Object)integralProduct.getId())).ge(TIntegralProduct::getRemainNum, (Object)exchangeNum)).set(TIntegralProduct::getRemainNum, (Object)(integralProduct.getRemainNum() - exchangeNum)));
        if (!update) {
            return ResponseUtil.getFailedMsg((String)"\u5e93\u5b58\u4e0d\u8db3");
        }
        if (ObjUtil.equals((Object)integralProduct.getPayType(), (Object)1)) {
            if (3 != integralProduct.getProductType()) {
                order.setState(Integer.valueOf(4));
            } else {
                order.setState(Integer.valueOf(1));
            }
        } else if (ObjUtil.equals((Object)integralProduct.getPayType(), (Object)3)) {
            // empty if block
        }
        this.integralMallOrderService.save((Object)order);
        MemberLoginBO mbrLoginInfo = LoginInfoUtil.getMbrLoginInfo();
        PrepareOrderReqVO prepareOrderReqVO = new PrepareOrderReqVO();
        prepareOrderReqVO.setOpenid(mbrLoginInfo.getOpenid());
        prepareOrderReqVO.setAmount(order.getPayCashAmount());
        prepareOrderReqVO.setIntegralOrderCode(order.getIntegralMallOrderCode());
        prepareOrderReqVO.setDescription(integralProduct.getProductName() + "(" + integralProduct.getProductNo() + ")");
        ResponseData prepayWithRequestPaymentResponseResponseData = this.apiWechatPayFeign.prepareOrder(prepareOrderReqVO);
        log.info("prepayWithRequestPaymentResponseResponseData: {}", (Object)JacksonUtil.bean2Json((Object)prepayWithRequestPaymentResponseResponseData));
        return ResponseUtil.getSuccessData((Object)"\u4e0b\u5355\u6210\u529f");
    }

    public ResponseData<Page<MobileOrderPageRespVO>> page(MobileOrderPageReqVO reqVO) {
        Page pageParam = new Page((long)reqVO.getPageNo().intValue(), (long)reqVO.getPageSize().intValue());
        Page page = (Page)this.integralMallOrderService.getBaseMapper().selectPage((IPage)pageParam, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TIntegralMallOrder::getMbrMemberCode, (Object)LoginInfoUtil.getMbrLoginInfo().getMbrMemberCode())).eq(TIntegralMallOrder::getValid, (Object)1)).eq(StrUtil.isNotBlank((CharSequence)reqVO.getOrderNo()), TIntegralMallOrder::getOrderNo, (Object)reqVO.getOrderNo())).orderByDesc(TIntegralMallOrder::getId));
        log.info("page: {}", (Object)JacksonUtil.bean2Json((Object)page));
        List orderList = page.getRecords();
        Page resultPage = (Page)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)page), Page.class);
        if (CollUtil.isNotEmpty((Collection)orderList)) {
            page.setRecords(null);
            List respList = JacksonUtil.json2List((String)JacksonUtil.bean2Json((Object)orderList), MobileOrderPageRespVO.class);
            resultPage.setRecords(respList);
        }
        return ResponseUtil.getSuccessData((Object)resultPage);
    }

    public ResponseData<MobileOrderDetailRespVO> getOrderDetail(String integralMallOrderCode) {
        log.info("getOrderDetail integralMallOrderCode: {}", (Object)integralMallOrderCode);
        TIntegralMallOrder order = this.integralMallOrderService.getOrderDetail(integralMallOrderCode);
        if (order == null) {
            return ResponseUtil.getFailedMsg((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        MobileOrderDetailRespVO respVO = (MobileOrderDetailRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)order), MobileOrderDetailRespVO.class);
        return ResponseUtil.getSuccessData((Object)respVO);
    }

    public ResponseData<String> confirmReceipt(String integralMallOrderCode) {
        MemberLoginBO mbrLoginInfo = LoginInfoUtil.getMbrLoginInfo();
        log.info("integralMallOrderCode: {}, mbrLoginInfo: {}", (Object)integralMallOrderCode, (Object)JacksonUtil.bean2Json((Object)mbrLoginInfo));
        boolean update = this.integralMallOrderService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TIntegralMallOrder::getIntegralMallOrderCode, (Object)integralMallOrderCode)).eq(TIntegralMallOrder::getMbrMemberCode, (Object)mbrLoginInfo.getMbrMemberCode())).eq(TIntegralMallOrder::getState, (Object)2)).eq(TIntegralMallOrder::getValid, (Object)1)).set(TIntegralMallOrder::getState, (Object)3));
        log.info("update: {}", (Object)JacksonUtil.bean2Json((Object)update));
        if (!update) {
            return ResponseUtil.getFailedMsg((String)"\u786e\u8ba4\u6536\u8d27\u5931\u8d25, \u8bf7\u68c0\u67e5\u8ba2\u5355\u72b6\u6001");
        }
        return ResponseUtil.getSuccessData((Object)"\u786e\u8ba4\u6536\u8d27\u6210\u529f");
    }
}

