/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.airport.mall.api.service.impl;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.bizvane.airport.mall.api.service.MQIntegralMallRefundOrderService;
import com.bizvane.airport.mall.domain.domain.po.TIntegralMallRefundOrder;
import com.bizvane.airport.mall.domain.service.TIntegralMallRefundOrderService;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.wechat.pay.java.core.exception.ValidationException;
import com.wechat.pay.java.service.refund.model.RefundNotification;
import com.wechat.pay.java.service.refund.model.Status;
import org.apache.rocketmq.client.producer.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MQIntegralMallRefundOrderServiceImpl
implements MQIntegralMallRefundOrderService {
    private static final Logger log = LoggerFactory.getLogger(MQIntegralMallRefundOrderServiceImpl.class);
    @Autowired
    private RocketMQTemplate rocketMQTemplate;
    @Autowired
    private TIntegralMallRefundOrderService tIntegralMallRefundOrderService;

    public String wechatPayRefundNotice(RefundNotification refundNotification) {
        try {
            Destination destination = new Destination();
            destination.setTopic("wechat_pay_order_refund_notice");
            SendResult send = this.rocketMQTemplate.send(destination, (Object)refundNotification);
            log.info("send: {}", (Object)JacksonUtil.bean2Json((Object)send));
            return "SUCCESS";
        }
        catch (ValidationException e) {
            log.error("sign verification failed", (Throwable)e);
            return "FAIL";
        }
    }

    public void wechatPayRefundProcess(RefundNotification refundNotification) {
        log.info("wechatPayRefundProcess refundNotification: {}", (Object)JacksonUtil.bean2Json((Object)refundNotification));
        String outRefundNo = refundNotification.getOutRefundNo();
        if (StrUtil.equals((CharSequence)refundNotification.getRefundStatus().name(), (CharSequence)Status.SUCCESS.name())) {
            boolean update = this.tIntegralMallRefundOrderService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TIntegralMallRefundOrder::getIntegralMallRefundOrderCode, (Object)outRefundNo)).ne(TIntegralMallRefundOrder::getState, (Object)3)).set(TIntegralMallRefundOrder::getState, (Object)3));
            log.info("wechatPayRefundProcess update: {}", (Object)update);
            if (update) {
                // empty if block
            }
        }
    }
}

