/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.airport.mall.api.service.impl;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.bizvane.airport.mall.api.service.MQIntegralMallOrderService;
import com.bizvane.airport.mall.api.service.MQIntegralMallRefundOrderService;
import com.bizvane.airport.mall.domain.domain.po.TIntegralMallOrder;
import com.bizvane.airport.mall.domain.service.TIntegralMallOrderService;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.wechat.pay.java.core.exception.ValidationException;
import com.wechat.pay.java.service.payments.model.Transaction;
import com.wechat.pay.java.service.refund.model.RefundNotification;
import com.wechat.pay.java.service.refund.model.Status;
import org.apache.rocketmq.client.producer.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MQIntegralMallOrderServiceImpl
implements MQIntegralMallOrderService {
    private static final Logger log = LoggerFactory.getLogger(MQIntegralMallOrderServiceImpl.class);
    @Autowired
    private TIntegralMallOrderService tIntegralMallOrderService;
    @Autowired
    private RocketMQTemplate rocketMQTemplate;
    @Autowired
    private MQIntegralMallRefundOrderService mqIntegralMallRefundOrderService;

    public String wechatPayNotice(Transaction transaction) {
        try {
            Destination destination = new Destination();
            destination.setTopic("wechat_pay_order_notice");
            SendResult send = this.rocketMQTemplate.send(destination, (Object)transaction);
            log.info("send: {}", (Object)JacksonUtil.bean2Json((Object)send));
            return "SUCCESS";
        }
        catch (ValidationException e) {
            log.error("sign verification failed", (Throwable)e);
            return "FAIL";
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void wechatPayProcess(Transaction transaction) {
        log.info("wechatPayProcess transaction: {}", (Object)JacksonUtil.bean2Json((Object)transaction));
        String outTradeNo = transaction.getOutTradeNo();
        if (transaction.getTradeState() == Transaction.TradeStateEnum.SUCCESS) {
            boolean update = this.tIntegralMallOrderService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TIntegralMallOrder::getIntegralMallOrderCode, (Object)outTradeNo)).ne(TIntegralMallOrder::getState, (Object)1)).set(TIntegralMallOrder::getState, (Object)1));
            log.info("wechatPayProcess SUCCESS update: {}", (Object)update);
            if (!update) return;
        }
        if (transaction.getTradeState() == Transaction.TradeStateEnum.CLOSED) {
            boolean update = this.tIntegralMallOrderService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TIntegralMallOrder::getIntegralMallOrderCode, (Object)outTradeNo)).ne(TIntegralMallOrder::getState, (Object)6)).set(TIntegralMallOrder::getState, (Object)6));
            log.info("wechatPayProcess CLOSED update: {}", (Object)update);
            if (!update) return;
        }
        if (transaction.getTradeState() != Transaction.TradeStateEnum.REFUND) return;
        boolean update = this.tIntegralMallOrderService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TIntegralMallOrder::getIntegralMallOrderCode, (Object)outTradeNo)).ne(TIntegralMallOrder::getState, (Object)5)).set(TIntegralMallOrder::getState, (Object)5));
        log.info("wechatPayProcess REFUND update: {}", (Object)update);
        if (!update) return;
        RefundNotification refundNotification = new RefundNotification();
        refundNotification.setOutTradeNo(outTradeNo);
        refundNotification.setRefundStatus(Status.SUCCESS);
        this.mqIntegralMallRefundOrderService.wechatPayRefundProcess(refundNotification);
    }
}

