/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.airport.mall.api.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.airport.mall.api.controller.req.QueryRefundOrderPageReqVO;
import com.bizvane.airport.mall.api.controller.req.UpdateAuditRefundOrderReqVO;
import com.bizvane.airport.mall.api.controller.resp.QueryRefundOrderPageRespVO;
import com.bizvane.airport.mall.api.login.LoginInfoUtil;
import com.bizvane.airport.mall.api.service.ApiIntegralRefundOrderService;
import com.bizvane.airport.mall.api.utils.ResponseUtil;
import com.bizvane.airport.mall.domain.domain.po.TIntegralMallRefundOrder;
import com.bizvane.airport.mall.domain.service.TIntegralMallOrderService;
import com.bizvane.airport.mall.domain.service.TIntegralMallRefundOrderService;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiIntegralRefundOrderServiceImpl
implements ApiIntegralRefundOrderService {
    private static final Logger log = LoggerFactory.getLogger(ApiIntegralRefundOrderServiceImpl.class);
    @Autowired
    private TIntegralMallOrderService tIntegralMallOrderService;
    @Autowired
    private TIntegralMallRefundOrderService refundOrderService;

    public ResponseData<Page<QueryRefundOrderPageRespVO>> page(QueryRefundOrderPageReqVO reqVO) {
        Page page = (Page)((Page)this.refundOrderService.getBaseMapper().selectPage((IPage)new Page((long)reqVO.getPageNo().intValue(), (long)reqVO.getPageSize().intValue()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TIntegralMallRefundOrder::getCreateUserName, (Object)LoginInfoUtil.getMbrLoginInfo().getMbrMemberCode())).eq(StrUtil.isNotBlank((CharSequence)reqVO.getRefundOrderNo()), TIntegralMallRefundOrder::getRefundOrderNo, (Object)reqVO.getRefundOrderNo())).eq(reqVO.getState() != null, TIntegralMallRefundOrder::getState, (Object)reqVO.getState())).orderByDesc(TIntegralMallRefundOrder::getId))).convert(refundOrder -> {
            QueryRefundOrderPageRespVO respVO = new QueryRefundOrderPageRespVO();
            respVO.setIntegralMallRefundOrderCode(refundOrder.getIntegralMallRefundOrderCode());
            respVO.setRefundOrderNo(refundOrder.getRefundOrderNo());
            respVO.setIntegralMallOrderCode(refundOrder.getIntegralMallOrderCode());
            respVO.setState(refundOrder.getState());
            return respVO;
        });
        return ResponseUtil.getSuccessData((Object)page);
    }

    public ResponseData<QueryRefundOrderPageRespVO> getRefundOrderDetail(String integralMallRefundOrderCode) {
        TIntegralMallRefundOrder refundOrder = (TIntegralMallRefundOrder)this.refundOrderService.getBaseMapper().selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TIntegralMallRefundOrder::getIntegralMallRefundOrderCode, (Object)integralMallRefundOrderCode)).orderByDesc(TIntegralMallRefundOrder::getId));
        QueryRefundOrderPageRespVO respVO = (QueryRefundOrderPageRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)refundOrder), QueryRefundOrderPageRespVO.class);
        return ResponseUtil.getSuccessData((Object)respVO);
    }

    public ResponseData<String> auditRefundOrder(UpdateAuditRefundOrderReqVO reqVO) {
        Boolean audit = reqVO.getAudit();
        String integralMallRefundOrderCode = reqVO.getIntegralMallRefundOrderCode();
        TIntegralMallRefundOrder refundOrder = (TIntegralMallRefundOrder)this.refundOrderService.getOne((Wrapper)new LambdaQueryWrapper().eq(TIntegralMallRefundOrder::getIntegralMallRefundOrderCode, (Object)integralMallRefundOrderCode));
        if (audit.booleanValue()) {
            Integer refundIntegral = reqVO.getRefundIntegral();
            Integer refundCashAmount = reqVO.getRefundCashAmount();
            refundIntegral = Optional.ofNullable(refundIntegral).orElse(0);
            refundCashAmount = Optional.ofNullable(refundCashAmount).orElse(0);
            if (refundIntegral > refundOrder.getRefundIntegral() || refundCashAmount > refundOrder.getRefundCashAmount()) {
                return ResponseUtil.getFailedMsg((String)"\u9000\u6b3e\u91d1\u989d\u6216\u79ef\u5206\u8d85\u51fa\u53ef\u9000\u91d1\u989d\u6216\u79ef\u5206");
            }
            refundOrder.setState(Integer.valueOf(2));
            refundOrder.setRefundIntegral(refundIntegral);
            refundOrder.setRefundCashAmount(refundCashAmount);
        } else {
            refundOrder.setState(Integer.valueOf(4));
        }
        refundOrder.setRemark(reqVO.getRemark());
        this.refundOrderService.updateById((Object)refundOrder);
        return ResponseUtil.getSuccessData((Object)"\u64cd\u4f5c\u6210\u529f");
    }
}

