/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.airport.mall.api.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.airport.mall.api.controller.req.AddOrUpdateProductReqVO;
import com.bizvane.airport.mall.api.controller.req.BatchUpdateStateProductReqVO;
import com.bizvane.airport.mall.api.controller.req.QueryProductPageListReqVO;
import com.bizvane.airport.mall.api.controller.resp.QueryProductPageListRespVO;
import com.bizvane.airport.mall.api.service.ApiIntegralProductService;
import com.bizvane.airport.mall.api.utils.ResponseUtil;
import com.bizvane.airport.mall.domain.domain.po.TIntegralProduct;
import com.bizvane.airport.mall.domain.service.TIntegralProductService;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiIntegralProductServiceImpl
implements ApiIntegralProductService {
    @Autowired
    private TIntegralProductService tIntegralProductService;

    public ResponseData<String> saveOrUpdate(AddOrUpdateProductReqVO reqVO) {
        Long integralProductId = reqVO.getIntegralProductId();
        Integer memberRangeType = reqVO.getMemberRangeType();
        List memberGroupCodeList = reqVO.getMemberGroupCodeList();
        List giftCouponIdList = reqVO.getGiftCouponIdList();
        TIntegralProduct tIntegralProduct = (TIntegralProduct)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)reqVO), TIntegralProduct.class);
        tIntegralProduct.setModifiedDate(new Date());
        tIntegralProduct.setValid(Integer.valueOf(1));
        if (ObjUtil.equals((Object)2, (Object)memberRangeType) && ObjUtil.isNotEmpty((Object)memberGroupCodeList)) {
            tIntegralProduct.setMemberGroupCode(memberGroupCodeList.stream().collect(Collectors.joining(",")));
        } else {
            tIntegralProduct.setMemberGroupCode("");
        }
        if (CollUtil.isNotEmpty((Collection)giftCouponIdList)) {
            tIntegralProduct.setGiftCouponCode(giftCouponIdList.stream().map(String::valueOf).collect(Collectors.joining(",")));
        }
        if (integralProductId == null) {
            tIntegralProduct.setIntegralProductCode(IdUtil.fastSimpleUUID());
            tIntegralProduct.setCreateDate(new Date());
            tIntegralProduct.setRemainNum(reqVO.getStockNum());
        }
        this.tIntegralProductService.saveOrUpdate((Object)tIntegralProduct);
        return ResponseUtil.getSuccessData((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    public ResponseData<String> delete(String integralProductCode) {
        this.tIntegralProductService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TIntegralProduct::getIntegralProductCode, (Object)integralProductCode)).set(TIntegralProduct::getValid, (Object)0));
        return ResponseUtil.getSuccessData((Object)"\u5220\u9664\u6210\u529f");
    }

    public ResponseData<QueryProductPageListRespVO> get(String integralProductCode) {
        TIntegralProduct integralProduct = (TIntegralProduct)this.tIntegralProductService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TIntegralProduct.class).eq(TIntegralProduct::getIntegralProductCode, (Object)integralProductCode)).eq(TIntegralProduct::getValid, (Object)1));
        QueryProductPageListRespVO respVO = (QueryProductPageListRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)integralProduct), QueryProductPageListRespVO.class);
        return ResponseUtil.getSuccessData((Object)respVO);
    }

    public ResponseData<String> copyProduct(String integralProductCode) {
        TIntegralProduct integralProduct = (TIntegralProduct)this.tIntegralProductService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TIntegralProduct.class).eq(TIntegralProduct::getIntegralProductCode, (Object)integralProductCode)).eq(TIntegralProduct::getValid, (Object)1));
        integralProduct.setId(null);
        integralProduct.setCreateDate(new Date());
        integralProduct.setModifiedDate(new Date());
        integralProduct.setValid(Integer.valueOf(1));
        this.tIntegralProductService.save((Object)integralProduct);
        return ResponseUtil.getSuccessData((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    public ResponseData<String> batchUpdateState(BatchUpdateStateProductReqVO reqVO) {
        List ids = reqVO.getIntegralProductIdList();
        Integer state = reqVO.getState();
        TIntegralProduct tIntegralProduct = new TIntegralProduct();
        tIntegralProduct.setState(state);
        tIntegralProduct.setModifiedDate(new Date());
        this.tIntegralProductService.update((Object)tIntegralProduct, (Wrapper)new LambdaQueryWrapper().in(TIntegralProduct::getId, (Collection)ids));
        return ResponseUtil.getSuccessData((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    public ResponseData<Page<QueryProductPageListRespVO>> getPageList(QueryProductPageListReqVO reqVO) {
        Page page = new Page((long)reqVO.getPageNo().intValue(), (long)reqVO.getPageSize().intValue());
        Page pageInfo = (Page)this.tIntegralProductService.page((IPage)page, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TIntegralProduct::getValid, (Object)1)).like(StrUtil.isNotBlank((CharSequence)reqVO.getProductName()), TIntegralProduct::getProductName, (Object)reqVO.getProductName())).like(StrUtil.isNotBlank((CharSequence)reqVO.getProductNo()), TIntegralProduct::getProductNo, (Object)reqVO.getProductNo())).eq(reqVO.getState() != null, TIntegralProduct::getState, (Object)reqVO.getState())).eq(reqVO.getHotState() != null, TIntegralProduct::getHotState, (Object)reqVO.getHotState()));
        List records = pageInfo.getRecords();
        pageInfo.setRecords(null);
        Page resultPage = (Page)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)pageInfo), Page.class);
        if (CollUtil.isNotEmpty((Collection)records)) {
            List resultList = records.stream().map(item -> (QueryProductPageListRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)item), QueryProductPageListRespVO.class)).collect(Collectors.toList());
            resultPage.setRecords(resultList);
        }
        return ResponseUtil.getSuccessData((Object)resultPage);
    }
}

