/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.airport.mall.api.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.airport.mall.api.controller.req.DeliverOrderReqVO;
import com.bizvane.airport.mall.api.controller.req.QueryIntegralMallOrderPageReqVO;
import com.bizvane.airport.mall.api.controller.resp.MobileOrderDetailRespVO;
import com.bizvane.airport.mall.api.controller.resp.QueryIntegralMallOrderPageRespVO;
import com.bizvane.airport.mall.api.service.ApiIntegralMallOrderService;
import com.bizvane.airport.mall.api.utils.ResponseUtil;
import com.bizvane.airport.mall.domain.config.WechatPayProperties;
import com.bizvane.airport.mall.domain.domain.bo.QueryIntegralMallOrderPageBO;
import com.bizvane.airport.mall.domain.domain.po.TIntegralMallOrder;
import com.bizvane.airport.mall.domain.domain.po.TIntegralProduct;
import com.bizvane.airport.mall.domain.service.TIntegralMallOrderService;
import com.bizvane.airport.mall.domain.service.TIntegralProductService;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import com.wechat.pay.java.service.payments.jsapi.JsapiServiceExtension;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiIntegralMallOrderServiceImpl
implements ApiIntegralMallOrderService {
    private static final Logger log = LoggerFactory.getLogger(ApiIntegralMallOrderServiceImpl.class);
    @Autowired
    private TIntegralMallOrderService tIntegralMallOrderService;
    @Autowired
    private TIntegralProductService tIntegralProductService;
    @Autowired
    private JsapiServiceExtension jsapiServiceExtension;
    @Autowired
    private WechatPayProperties wechatPayProperties;

    public ResponseData<Page<QueryIntegralMallOrderPageRespVO>> getPageList(QueryIntegralMallOrderPageReqVO reqVO) {
        Page page = new Page((long)reqVO.getPageNo().intValue(), (long)reqVO.getPageSize().intValue());
        Page pageInfo = this.tIntegralMallOrderService.getList(page, (QueryIntegralMallOrderPageBO)reqVO);
        List list = pageInfo.getRecords();
        pageInfo.setRecords(null);
        Page resultPage = (Page)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)pageInfo), Page.class);
        if (CollUtil.isNotEmpty((Collection)list)) {
            List mbrMemberCodeList = list.stream().map(TIntegralMallOrder::getMbrMemberCode).collect(Collectors.toList());
            List integralProductCodeList = list.stream().map(TIntegralMallOrder::getIntegralProductCode).collect(Collectors.toList());
            List productList = this.tIntegralProductService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TIntegralProduct::getValid, (Object)1)).in(TIntegralProduct::getIntegralProductCode, integralProductCodeList));
            Map<String, TIntegralProduct> productMap = productList.stream().collect(Collectors.toMap(TIntegralProduct::getIntegralProductCode, item -> item, (o1, o2) -> o2));
            List resultList = list.stream().map(item -> {
                QueryIntegralMallOrderPageRespVO respVO = (QueryIntegralMallOrderPageRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)item), QueryIntegralMallOrderPageRespVO.class);
                TIntegralProduct tIntegralProduct = (TIntegralProduct)productMap.get(item.getIntegralProductCode());
                if (tIntegralProduct != null) {
                    respVO.setProductName(tIntegralProduct.getProductName());
                    respVO.setProductNo(tIntegralProduct.getProductNo());
                }
                return respVO;
            }).collect(Collectors.toList());
            resultPage.setRecords(resultList);
        }
        return ResponseUtil.getSuccessData((Object)resultPage);
    }

    public ResponseData<MobileOrderDetailRespVO> getOrderDetail(String integralMallOrderCode) {
        log.info("getOrderDetail integralMallOrderCode: {}", (Object)integralMallOrderCode);
        TIntegralMallOrder order = this.tIntegralMallOrderService.getOrderDetail(integralMallOrderCode);
        if (order == null) {
            return ResponseUtil.getFailedMsg((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        MobileOrderDetailRespVO respVO = (MobileOrderDetailRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)order), MobileOrderDetailRespVO.class);
        return ResponseUtil.getSuccessData((Object)respVO);
    }

    public ResponseData<String> deliverOrder(DeliverOrderReqVO reqVO) {
        String integralMallOrderCode = reqVO.getIntegralMallOrderCode();
        TIntegralMallOrder order = (TIntegralMallOrder)this.tIntegralMallOrderService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TIntegralMallOrder::getIntegralMallOrderCode, (Object)integralMallOrderCode)).eq(TIntegralMallOrder::getValid, (Object)1));
        if (order.getState() != 1) {
            return ResponseUtil.getFailedMsg((String)"\u8ba2\u5355\u72b6\u6001\u975e\u5f85\u53d1\u8d27");
        }
        order.setState(Integer.valueOf(2));
        order.setCourierCompanyCode(reqVO.getCourierCompanyCode());
        order.setCourierCompanyName(reqVO.getCourierCompanyName());
        order.setCourierNo(reqVO.getCourierNo());
        order.setCourierCompanyCode(reqVO.getCourierCompanyCode());
        order.setDeliveryDate(new Date());
        this.tIntegralMallOrderService.updateById((Object)order);
        return ResponseUtil.getSuccessData((Object)"\u53d1\u8d27\u6210\u529f");
    }

    public ResponseData<String> selfPickUpOrder(String integralMallOrderCode) {
        TIntegralMallOrder order = (TIntegralMallOrder)this.tIntegralMallOrderService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TIntegralMallOrder::getIntegralMallOrderCode, (Object)integralMallOrderCode)).eq(TIntegralMallOrder::getValid, (Object)1));
        if (order.getState() != 1) {
            return ResponseUtil.getFailedMsg((String)"\u8ba2\u5355\u72b6\u6001\u975e\u5f85\u81ea\u63d0");
        }
        order.setState(Integer.valueOf(3));
        order.setReceiveDate(new Date());
        this.tIntegralMallOrderService.updateById((Object)order);
        return ResponseUtil.getSuccessData((Object)"\u81ea\u63d0\u6210\u529f");
    }
}

