/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.fitmentserviceimpl.impl;

import com.alibaba.fastjson.JSON;
import com.bizvane.fitmentservice.interfaces.MemberLevelService;
import com.bizvane.fitmentservice.models.po.AppletResourcesPO;
import com.bizvane.fitmentservice.models.po.AppletResourcesPOExample;
import com.bizvane.fitmentservice.models.po.AppletVipCartPO;
import com.bizvane.fitmentservice.models.po.AppletVipCartPOExample;
import com.bizvane.fitmentservice.models.vo.MbrLevelVO;
import com.bizvane.fitmentservice.utils.TimeUtils;
import com.bizvane.fitmentserviceimpl.mappers.AppletResourcesPOMapper;
import com.bizvane.fitmentserviceimpl.mappers.AppletVipCartPOMapper;
import com.bizvane.members.facade.models.MbrLevelModel;
import com.bizvane.members.facade.service.api.MemberLevelApiService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MemberLevelServiceImpl
implements MemberLevelService {
    private static final Logger log = LoggerFactory.getLogger(MemberLevelServiceImpl.class);
    @Autowired
    private MemberLevelApiService memberLevelApiService;
    @Autowired
    private AppletVipCartPOMapper appletVipCartPOMapper;
    @Autowired
    private AppletResourcesPOMapper appletResourcesPOMapper;

    public ResponseData selectAllMemberCardByBrandId(Long brandId, SysAccountPO sysAccountPO, Integer code) {
        ResponseData responseData = new ResponseData();
        if (brandId == null) {
            responseData.setMessage("\u54c1\u724cid\u4e3a\u7a7a");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        if (code == null) {
            responseData.setMessage("\u6a21\u5757code\u4e3a\u7a7a");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        List mbrLevelModelList = (List)this.memberLevelApiService.queryAllLevelList(brandId).getData();
        AppletVipCartPOExample appletVipCartPOExample = new AppletVipCartPOExample();
        appletVipCartPOExample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andSysBrandIdEqualTo(brandId);
        List appletVipCartPOList = this.appletVipCartPOMapper.selectByExample(appletVipCartPOExample);
        if (mbrLevelModelList == null || mbrLevelModelList.size() == 0) {
            responseData.setMessage("\u8be5\u54c1\u724c\u672a\u8bbe\u7f6e\u4f1a\u5458\u7b49\u7ea7");
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            return responseData;
        }
        ArrayList<Long> mbrLevelIds = new ArrayList<Long>();
        for (Object mbrLevelModel : mbrLevelModelList) {
            mbrLevelIds.add(mbrLevelModel.getMbrLevelId());
        }
        ArrayList<Long> appletVipCardGradeIds = null;
        if (CollectionUtils.isNotEmpty((Collection)appletVipCartPOList)) {
            appletVipCardGradeIds = new ArrayList<Long>();
            for (Object appletVipCartPO : appletVipCartPOList) {
                appletVipCardGradeIds.add(appletVipCartPO.getGradeId());
            }
        }
        ArrayList<Long> addList = new ArrayList<Long>();
        addList.addAll(mbrLevelIds);
        if (appletVipCardGradeIds != null) {
            addList.removeAll(appletVipCardGradeIds);
        }
        if (addList != null && addList.size() > 0) {
            for (Long gradeId : addList) {
                AppletVipCartPO appletVipCartPO = new AppletVipCartPO();
                appletVipCartPO.setSysBrandId(brandId);
                appletVipCartPO.setGradeId(gradeId);
                appletVipCartPO.setCreateDate(TimeUtils.getNowTime());
                appletVipCartPO.setCreateUserId(sysAccountPO.getSysAccountId());
                appletVipCartPO.setCreateUserName(sysAccountPO.getName());
                appletVipCartPO.setSysCompanyId(sysAccountPO.getSysCompanyId());
                this.appletVipCartPOMapper.insertSelective(appletVipCartPO);
                responseData.setMessage("\u5411\u4f1a\u5458\u5361\u8868\u4e2d\u589e\u52a0\u65b0\u6570\u636e\u6210\u529f");
            }
        }
        AppletVipCartPOExample appletVipCartPOExample2 = new AppletVipCartPOExample();
        appletVipCartPOExample2.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andSysBrandIdEqualTo(brandId).andValidEqualTo(Boolean.valueOf(true));
        List appletVipCartPOS = this.appletVipCartPOMapper.selectByExample(appletVipCartPOExample2);
        ArrayList<MbrLevelVO> mbrLevelVOS = new ArrayList<MbrLevelVO>();
        for (MbrLevelModel mbrLevelModel : mbrLevelModelList) {
            MbrLevelVO mbrLevelVO = new MbrLevelVO();
            BeanUtils.copyProperties((Object)mbrLevelModel, (Object)mbrLevelVO);
            for (AppletVipCartPO appletVipCartPO : appletVipCartPOS) {
                if (mbrLevelModel.getMbrLevelId().compareTo(appletVipCartPO.getGradeId()) != 0) continue;
                mbrLevelVO.setReveal(appletVipCartPO.getReveal());
                mbrLevelVO.setSort(appletVipCartPO.getSort());
                mbrLevelVO.setAppletVipCardId(appletVipCartPO.getAppletVipCardId());
                mbrLevelVO.setCardStyle(appletVipCartPO.getCardStyle());
                mbrLevelVO.setIsImg(appletVipCartPO.getIsImg());
            }
            mbrLevelVOS.add(mbrLevelVO);
        }
        Collections.sort(mbrLevelVOS, new /* Unavailable Anonymous Inner Class!! */);
        if (mbrLevelVOS.size() != mbrLevelModelList.size()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u4e22\u5931\u4f1a\u5458\u7b49\u7ea7\u6570\u636e");
            responseData.setData(mbrLevelVOS);
            return responseData;
        }
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData(mbrLevelVOS);
        return responseData;
    }

    public ResponseData<AppletResourcesPO> getAppletResourcesInfo(String modularCode, Long brandId, Long companyId) {
        AppletResourcesPOExample appletResourcesPOExample = new AppletResourcesPOExample();
        appletResourcesPOExample.createCriteria().andSysBrandIdEqualTo(brandId).andModularCodeEqualTo("M007").andValidEqualTo(Boolean.valueOf(true)).andModularTypeEqualTo("1");
        List list = this.appletResourcesPOMapper.selectByExample(appletResourcesPOExample);
        ResponseData responseData = new ResponseData();
        if (list != null && list.size() > 0) {
            responseData.setData(list.get(0));
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            return responseData;
        }
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        responseData.setMessage(SysResponseEnum.FAILED.getMessage());
        return responseData;
    }

    public ResponseData<List<MbrLevelVO>> updateSortAndReveal(List<AppletVipCartPO> appletVipCartPOList) {
        log.info("\u66f4\u65b0\u6392\u5e8f\u63a5\u53e3\u5165\u53c2\uff1a {}", (Object)JSON.toJSONString(appletVipCartPOList));
        for (AppletVipCartPO apo : appletVipCartPOList) {
            this.appletVipCartPOMapper.updateByPrimaryKeySelective(apo);
        }
        return new ResponseData();
    }

    public ResponseData getAppletLevelCardList(Long brandId) {
        ResponseData responseData = new ResponseData();
        if (brandId == null) {
            responseData.setMessage("\u54c1\u724cid\u4e3a\u7a7a");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        List mbrLevelModelList = (List)this.memberLevelApiService.queryAllLevelList(brandId).getData();
        AppletVipCartPOExample appletVipCartPOExample2 = new AppletVipCartPOExample();
        appletVipCartPOExample2.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andSysBrandIdEqualTo(brandId).andValidEqualTo(Boolean.valueOf(true));
        List appletVipCartPOS = this.appletVipCartPOMapper.selectByExample(appletVipCartPOExample2);
        ArrayList<MbrLevelVO> mbrLevelVOS = new ArrayList<MbrLevelVO>();
        for (MbrLevelModel mbrLevelModel : mbrLevelModelList) {
            MbrLevelVO mbrLevelVO = new MbrLevelVO();
            BeanUtils.copyProperties((Object)mbrLevelModel, (Object)mbrLevelVO);
            for (AppletVipCartPO appletVipCartPO : appletVipCartPOS) {
                if (mbrLevelModel.getMbrLevelId().compareTo(appletVipCartPO.getGradeId()) != 0) continue;
                mbrLevelVO.setReveal(appletVipCartPO.getReveal());
                mbrLevelVO.setSort(appletVipCartPO.getSort());
                mbrLevelVO.setCardStyle(appletVipCartPO.getCardStyle());
                mbrLevelVO.setIsImg(appletVipCartPO.getIsImg());
            }
            if (mbrLevelVO.getReveal() == null || !mbrLevelVO.getReveal().booleanValue()) continue;
            mbrLevelVOS.add(mbrLevelVO);
        }
        Collections.sort(mbrLevelVOS, new /* Unavailable Anonymous Inner Class!! */);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData(mbrLevelVOS);
        return responseData;
    }
}

