/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.fitmentserviceimpl.impl;

import com.bizvane.fitmentservice.interfaces.AppletTemplateService;
import com.bizvane.fitmentservice.models.po.AppletBrandTemplateRelPO;
import com.bizvane.fitmentservice.models.po.AppletBrandTemplateRelPOExample;
import com.bizvane.fitmentservice.models.po.AppletTemplatePOExample;
import com.bizvane.fitmentservice.utils.TimeUtils;
import com.bizvane.fitmentserviceimpl.mappers.AppletBrandTemplateRelPOMapper;
import com.bizvane.fitmentserviceimpl.mappers.AppletTemplatePOMapper;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppletTemplateServiceImpl
implements AppletTemplateService {
    @Autowired
    private AppletTemplatePOMapper appletTemplatePOMapper;
    @Autowired
    private AppletBrandTemplateRelPOMapper appletBrandTemplateRelPOMapper;

    public ResponseData getTemplateByBrandId(Long brandId) {
        ResponseData responseData = new ResponseData();
        if (brandId == null) {
            responseData.setMessage("\u54c1\u724cid\u4e3a\u7a7a");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        AppletBrandTemplateRelPOExample appletBrandTemplateRelPOExample = new AppletBrandTemplateRelPOExample();
        appletBrandTemplateRelPOExample.createCriteria().andSysBrandIdEqualTo(brandId).andValidEqualTo(Boolean.valueOf(true));
        List appletBrandTemplateRelPOList = this.appletBrandTemplateRelPOMapper.selectByExample(appletBrandTemplateRelPOExample);
        if (appletBrandTemplateRelPOList == null || appletBrandTemplateRelPOList.size() == 0) {
            responseData.setMessage("\u8be5\u54c1\u724c\u8fd8\u672a\u8bbe\u7f6e\u6a21\u677f");
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setData(new ArrayList());
            return responseData;
        }
        AppletBrandTemplateRelPO appletBrandTemplateRelPO = (AppletBrandTemplateRelPO)appletBrandTemplateRelPOList.get(0);
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)appletBrandTemplateRelPO);
        return responseData;
    }

    public ResponseData updateTemplate(AppletBrandTemplateRelPO appletBrandTemplateRelPO, SysAccountPO sysAccountPO) {
        ResponseData responseData = new ResponseData();
        if (appletBrandTemplateRelPO.getSysBrandId() == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u54c1\u724cid\u4e3a\u7a7a");
            return responseData;
        }
        if (appletBrandTemplateRelPO.getIsokBottom() == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u54c1\u724c\u6a21\u677fid\u4e3a\u7a7a");
            return responseData;
        }
        AppletBrandTemplateRelPOExample appletBrandTemplateRelPOExample = new AppletBrandTemplateRelPOExample();
        appletBrandTemplateRelPOExample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andSysBrandIdEqualTo(appletBrandTemplateRelPO.getSysBrandId());
        List appletBrandTemplateRelPOList = this.appletBrandTemplateRelPOMapper.selectByExample(appletBrandTemplateRelPOExample);
        if (appletBrandTemplateRelPOList == null || appletBrandTemplateRelPOList.size() == 0) {
            responseData.setMessage("\u8be5\u54c1\u724c\u8fd8\u672a\u9009\u62e9\u6a21\u677f");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        appletBrandTemplateRelPO.setModifiedDate(TimeUtils.getNowTime());
        appletBrandTemplateRelPO.setModifiedUserName(sysAccountPO.getName());
        appletBrandTemplateRelPO.setModifiedUserId(sysAccountPO.getSysAccountId());
        appletBrandTemplateRelPO.setSysCompanyId(sysAccountPO.getSysCompanyId());
        int count = this.appletBrandTemplateRelPOMapper.updateByExampleSelective(appletBrandTemplateRelPO, appletBrandTemplateRelPOExample);
        if (count == 0) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u66f4\u65b0\u6a21\u677f\u6761\u6570\u4e3a0");
            return responseData;
        }
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage("\u66f4\u65b0\u6a21\u677f\u6210\u529f");
        return responseData;
    }

    public ResponseData getAppletTemplate() {
        ResponseData responseData = new ResponseData();
        AppletTemplatePOExample appletTemplatePOExample = new AppletTemplatePOExample();
        appletTemplatePOExample.createCriteria().andValidEqualTo(Boolean.valueOf(true));
        List list = this.appletTemplatePOMapper.selectByExample(appletTemplatePOExample);
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)list);
        return responseData;
    }
}

