/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.fitmentserviceimpl.controllers;

import com.bizvane.fitmentservice.interfaces.MemberLevelService;
import com.bizvane.fitmentservice.interfaces.MembershipCardService;
import com.bizvane.fitmentservice.models.po.AppletResourcesPO;
import com.bizvane.fitmentservice.models.po.AppletVipCartPO;
import com.bizvane.fitmentservice.models.vo.AppletVipCardVo;
import com.bizvane.fitmentservice.models.vo.MbrLevelVO;
import com.bizvane.members.facade.service.api.MemberLevelApiService;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/membershipCard"})
public class MembershipCardController {
    @Autowired
    private MembershipCardService membershipCardService;
    @Autowired
    private MemberLevelApiService memberLevelApiService;
    @Autowired
    private MemberLevelService memberLevelService;

    @RequestMapping(value={"/updateByPrimaryKeySelective"}, method={RequestMethod.POST})
    public ResponseData updateByPrimaryKeySelective(AppletVipCartPO appletVipCartPO, String codeType, HttpServletRequest request) {
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        return this.membershipCardService.updateByPrimaryKeySelective(appletVipCartPO, codeType, sysAccountPO);
    }

    @RequestMapping(value={"/selectAllMemberCardByBrandId"}, method={RequestMethod.POST})
    public ResponseData selectAllMemberCardByBrandId(Long brandId, HttpServletRequest request, Integer code) {
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        return this.memberLevelService.selectAllMemberCardByBrandId(brandId, sysAccountPO, code);
    }

    @RequestMapping(value={"/updateVipCardUpGradeInfo"})
    public ResponseData updateVipCardUpGradeInfo(AppletVipCardVo appletVipCartVO, HttpServletRequest request) {
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        return this.membershipCardService.updateVipCardUpGradeInfo(appletVipCartVO, sysAccountPO);
    }

    @RequestMapping(value={"/showVipCardUpGradeInfo"})
    public ResponseData showVipCardUpGradeInfo(HttpServletRequest request) {
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        return this.membershipCardService.showVipCardUpGradeInfo(sysAccountPO.getBrandId());
    }

    @RequestMapping(value={"/showVipCardStyle"})
    public ResponseData showVipCardStyle(Long gradeId, HttpServletRequest request) {
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        return this.membershipCardService.showVipCardStyle(gradeId, sysAccountPO);
    }

    @RequestMapping(value={"/showMemberBaseField"})
    public ResponseData showMemberBaseField(Long sysCompanyId, Long sysBrandId) {
        return this.membershipCardService.showMemberBaseField(sysCompanyId, sysBrandId);
    }

    @RequestMapping(value={"/getAppletResourcesInfo"}, method={RequestMethod.POST})
    public ResponseData<AppletResourcesPO> getAppletResourcesPO(String modularCode, Long brandId, Long companyId) {
        return this.memberLevelService.getAppletResourcesInfo(modularCode, brandId, companyId);
    }

    @RequestMapping(value={"/updateSortAndReveal"}, method={RequestMethod.POST})
    public ResponseData<AppletResourcesPO> updateSortAndReveal(@RequestBody List<AppletVipCartPO> appletVipCartPOList) {
        return this.memberLevelService.updateSortAndReveal(appletVipCartPOList);
    }

    @RequestMapping(value={"/getAppletLevelCardList"}, method={RequestMethod.POST})
    public ResponseData<List<MbrLevelVO>> getAppletLevelCardList(@RequestParam Long brandId) {
        return this.memberLevelService.getAppletLevelCardList(brandId);
    }
}

