/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.fitmentserviceimpl.utils;

import com.bizvane.fitmentservice.models.po.SysQiNiuConfigPo;
import com.bizvane.fitmentservice.models.po.SysQiNiuConfigPoExample;
import com.bizvane.fitmentservice.models.vo.QiNiuVo;
import com.bizvane.fitmentserviceimpl.mappers.SysQiNiuConfigPoMapper;
import com.google.gson.Gson;
import com.qiniu.common.QiniuException;
import com.qiniu.common.Zone;
import com.qiniu.http.Response;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.BatchStatus;
import com.qiniu.storage.model.DefaultPutRet;
import com.qiniu.storage.model.FileInfo;
import com.qiniu.util.Auth;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QiNiuUtil {
    private static final Logger log = LoggerFactory.getLogger(QiNiuUtil.class);
    @Autowired
    private SysQiNiuConfigPoMapper sysQiNiuConfigPoMapper;
    private static String accessKey;
    private static String secretKey;

    public static void main(String[] args) throws Exception {
        QiNiuUtil qiNiuUtil = new QiNiuUtil();
        File file = new File("C:\\JP_2018-07-21_1920x1080.JPG");
        String bucketNm = "bizvane01";
        qiNiuUtil.upload(bucketNm, file);
        qiNiuUtil.getFileInfo(bucketNm);
    }

    @PostConstruct
    public void QiNiuUtil() {
        SysQiNiuConfigPoExample example = new SysQiNiuConfigPoExample();
        List sysQiNiuConfigPos = null;
        if (CollectionUtils.isNotEmpty(sysQiNiuConfigPos)) {
            SysQiNiuConfigPo sysQiNiuConfigPo = (SysQiNiuConfigPo)sysQiNiuConfigPos.get(0);
            accessKey = sysQiNiuConfigPo.getAccessKey();
            secretKey = sysQiNiuConfigPo.getSecretKey();
        }
    }

    public void getFileInfo(String bucketNm) {
        try {
            BucketManager bucketManager = this.getBucketManager();
            String prefix = "";
            int limit = 1000;
            String delimiter = "";
            BucketManager.FileListIterator fileListIterator = bucketManager.createFileListIterator(bucketNm, prefix, limit, delimiter);
            while (fileListIterator.hasNext()) {
                FileInfo[] items;
                for (FileInfo item : items = fileListIterator.next()) {
                    log.info(item.key);
                }
            }
        }
        catch (Exception e) {
            log.error("errorMessage:", (Throwable)e);
        }
    }

    public void getBucketsInfo() {
        try {
            String[] bucketNms;
            BucketManager bucketManager = this.getBucketManager();
            for (String bucket : bucketNms = bucketManager.buckets()) {
                log.info(bucket);
            }
        }
        catch (Exception e) {
            log.error("errorMessage:", (Throwable)e);
        }
    }

    public QiNiuVo deletes(String bucketNm, String[] keys) {
        QiNiuVo qiNiuVo = null;
        try {
            if (keys.length > 1000) {
                return new QiNiuVo(false);
            }
            BucketManager.BatchOperations batchOperations = new BucketManager.BatchOperations();
            batchOperations.addDeleteOp(bucketNm, keys);
            BucketManager bucketManager = this.getBucketManager();
            Response response = bucketManager.batch(batchOperations);
            BatchStatus[] batchStatusList = (BatchStatus[])response.jsonToObject(BatchStatus[].class);
            for (int i = 0; i < keys.length; ++i) {
                BatchStatus status = batchStatusList[i];
                String key = keys[i];
                log.info(key + "\t");
                if (status.code != 200) {
                    log.info(status.data.error);
                    return new QiNiuVo(false);
                }
                log.info("delete success");
            }
            qiNiuVo = new QiNiuVo(true);
        }
        catch (Exception e) {
            qiNiuVo = new QiNiuVo(false);
        }
        return qiNiuVo;
    }

    public QiNiuVo delete(String bucketNm, String key) {
        QiNiuVo result = null;
        try {
            BucketManager mg = this.getBucketManager();
            mg.delete(bucketNm, key);
            result = new QiNiuVo(true);
        }
        catch (Exception e) {
            result = new QiNiuVo(false);
        }
        return result;
    }

    public QiNiuVo upload(String bucketNm, InputStream in, String key) {
        QiNiuVo result = null;
        try {
            UploadManager uploadManager = this.getUploadManager(bucketNm);
            String token = this.getToken(bucketNm);
            Response response = uploadManager.put(in, key, token, null, null);
            DefaultPutRet putRet = (DefaultPutRet)new Gson().fromJson(response.bodyString(), DefaultPutRet.class);
            log.info(putRet.key);
            log.info(putRet.hash);
            result = new QiNiuVo(true, putRet.key);
        }
        catch (Exception e) {
            result = new QiNiuVo(false);
        }
        return result;
    }

    public QiNiuVo upload(String bucketNm, File file) {
        QiNiuVo result = null;
        try {
            UploadManager uploadManager = this.getUploadManager(bucketNm);
            String token = this.getToken(bucketNm);
            Response response = uploadManager.put(file.getAbsolutePath(), this.newName(file.getName()), token);
            DefaultPutRet putRet = (DefaultPutRet)new Gson().fromJson(response.bodyString(), DefaultPutRet.class);
            log.info(putRet.key);
            log.info(putRet.hash);
            result = new QiNiuVo(true, putRet.key);
        }
        catch (QiniuException e) {
            log.error("errorMessage:", (Throwable)e);
            result = new QiNiuVo(false);
        }
        return result;
    }

    public String newName(String oldName) {
        String[] datas = oldName.split("\\.");
        String type = datas[datas.length - 1];
        String newName = UUID.randomUUID().toString() + "." + type;
        return newName;
    }

    public UploadManager getUploadManager(String bucketNm) {
        Configuration cfg = new Configuration(Zone.zone0());
        UploadManager uploadManager = new UploadManager(cfg);
        return uploadManager;
    }

    public BucketManager getBucketManager() {
        Configuration cfg = new Configuration(Zone.zone0());
        Auth auth = Auth.create((String)accessKey, (String)secretKey);
        BucketManager bucketManager = new BucketManager(auth, cfg);
        return bucketManager;
    }

    public String getToken(String bucketNm) {
        Auth auth = Auth.create((String)accessKey, (String)secretKey);
        String upToken = auth.uploadToken(bucketNm);
        return upToken;
    }
}

