/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.fitmentserviceimpl.impl;

import com.bizvane.fitmentservice.interfaces.AppletSlideJumpService;
import com.bizvane.fitmentservice.models.po.AppletResourcesPO;
import com.bizvane.fitmentservice.models.po.AppletResourcesPOExample;
import com.bizvane.fitmentservice.models.po.AppletSlideJumpPO;
import com.bizvane.fitmentservice.models.po.AppletSlideJumpPOExample;
import com.bizvane.fitmentserviceimpl.mappers.AppletResourcesPOMapper;
import com.bizvane.fitmentserviceimpl.mappers.AppletSlideJumpPOMapper;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageHelper;
import java.util.Date;
import java.util.List;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppletSlideJumpServiceImpl
implements AppletSlideJumpService {
    private static final Logger log = LoggerFactory.getLogger(AppletSlideJumpServiceImpl.class);
    @Autowired
    private AppletSlideJumpPOMapper appletSlideJumpPOMapper;
    @Autowired
    private AppletResourcesPOMapper appletResourcesPOMapper;

    public ResponseData<List<AppletSlideJumpPO>> getAppletsInfo(AppletSlideJumpPO appletSlideJumpPO) {
        log.info("\u65b9\u6cd5:getAppletsInfo\u5165\u53c2:{},{}", (Object)appletSlideJumpPO.getSysBrandId(), (Object)appletSlideJumpPO.getSysCompanyId());
        ResponseData data = new ResponseData();
        AppletSlideJumpPOExample example = new AppletSlideJumpPOExample();
        PageHelper.startPage((int)appletSlideJumpPO.getPageNumber(), (int)appletSlideJumpPO.getPageSize(), (boolean)false);
        example.setOrderByClause("create_date desc");
        example.createCriteria().andSysBrandIdEqualTo(appletSlideJumpPO.getSysBrandId()).andSysCompanyIdEqualTo(appletSlideJumpPO.getSysCompanyId()).andValidEqualTo(Boolean.valueOf(true));
        List list = this.appletSlideJumpPOMapper.selectByExample(example);
        data.setData((Object)list);
        data.setCode(SysResponseEnum.SUCCESS.getCode());
        data.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return data;
    }

    public ResponseData insertAppletsInfo(AppletSlideJumpPO appletSlideJumpPO) {
        int state = 0;
        if (appletSlideJumpPO.getId() != null) {
            log.info("\u66f4\u65b0id,{}", (Object)appletSlideJumpPO.getId());
            log.info("1.\u66f4\u65b0\u8f6e\u64ad\u56fe\u9875\u9762\u5c55\u793a\u4fe1\u606f");
            AppletResourcesPOExample appletResourcesPOExample = new AppletResourcesPOExample();
            appletResourcesPOExample.createCriteria().andSlideJumpIdEqualTo(appletSlideJumpPO.getId()).andValidEqualTo(Boolean.valueOf(true));
            AppletResourcesPO po = new AppletResourcesPO();
            po.setAppletName(appletSlideJumpPO.getAppletName());
            po.setAppid(appletSlideJumpPO.getAppid());
            po.setPageName(appletSlideJumpPO.getPageName());
            po.setJumpUrl(appletSlideJumpPO.getPagePath());
            po.setModifiedUserId(appletSlideJumpPO.getCreateUserId());
            po.setModifiedDate(new Date());
            this.appletResourcesPOMapper.updateByExampleSelective(po, appletResourcesPOExample);
            log.info("2.\u66f4\u65b0\u5173\u8054\u5c0f\u7a0b\u5e8f\u5217\u8868\u4fe1\u606f");
            appletSlideJumpPO.setModifiedUserId(appletSlideJumpPO.getCreateUserId());
            appletSlideJumpPO.setModifiedDate(new Date());
            state = this.appletSlideJumpPOMapper.updateByPrimaryKeySelective(appletSlideJumpPO);
        } else {
            log.info("=======\u65b0\u589e=======");
            appletSlideJumpPO.setCreateDate(new Date());
            appletSlideJumpPO.setValid(Boolean.valueOf(true));
            state = this.appletSlideJumpPOMapper.insertSelective(appletSlideJumpPO);
        }
        if (state == 1) {
            return this.result(true);
        }
        return this.result(false);
    }

    public ResponseData delete(Long id) {
        log.info("===\u5220\u9664==={}", (Object)id);
        int state = this.appletSlideJumpPOMapper.deleteByPrimaryKey(id);
        if (state == 1) {
            return this.result(true);
        }
        return this.result(false);
    }

    public ResponseData<List<AppletSlideJumpPO>> getPageInfoByAppid(String appid) {
        log.info("\u9009\u62e9\u5c0f\u7a0b\u5e8f\u9875\u9762\u4fe1\u606f appid{}", (Object)appid);
        ResponseData data = new ResponseData();
        AppletSlideJumpPOExample example = new AppletSlideJumpPOExample();
        example.createCriteria().andAppidEqualTo(appid).andValidEqualTo(Boolean.valueOf(true));
        List list = this.appletSlideJumpPOMapper.selectByExample(example);
        data.setData((Object)list);
        data.setCode(SysResponseEnum.SUCCESS.getCode());
        data.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return data;
    }

    public ResponseData<List<String>> getJumpAppIdByBrandId(Long sysBrandId) {
        ResponseData data = new ResponseData();
        List lists = this.appletSlideJumpPOMapper.getJumpAppIdByBrandId(sysBrandId);
        data.setData((Object)lists);
        data.setCode(SysResponseEnum.SUCCESS.getCode());
        data.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return data;
    }

    private ResponseData<T> result(boolean isok) {
        ResponseData data = new ResponseData();
        if (isok) {
            data.setMessage(SysResponseEnum.SUCCESS.getMessage());
            data.setCode(SysResponseEnum.SUCCESS.getCode());
        } else {
            data.setMessage(SysResponseEnum.FAILED.getMessage());
            data.setCode(SysResponseEnum.FAILED.getCode());
        }
        return data;
    }
}

