/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.fitmentserviceimpl.impl;

import com.bizvane.fitmentservice.interfaces.AppletBrandIntroduceService;
import com.bizvane.fitmentservice.models.po.AppletBrandIntroducePO;
import com.bizvane.fitmentservice.models.po.AppletBrandIntroducePOExample;
import com.bizvane.fitmentserviceimpl.mappers.AppletBrandIntroducePOMapper;
import com.bizvane.fitmentserviceimpl.utils.QiNiuConfig;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppletBrandIntroduceServiceImpl
implements AppletBrandIntroduceService {
    @Autowired
    private AppletBrandIntroducePOMapper appletBrandIntroducePOMapper;
    @Autowired
    private QiNiuConfig qiNiuConfig;

    public ResponseData saveOrUpdateBrandIntroduce(AppletBrandIntroducePO appletBrandIntroducePO, SysAccountPO stageUser) {
        if (appletBrandIntroducePO.getAppletBrandIntroduceId() == null) {
            return this.save(appletBrandIntroducePO, stageUser);
        }
        return this.update(appletBrandIntroducePO, stageUser);
    }

    public ResponseData selectBrandIntroduce(Long sysBrandId) {
        ResponseData data = new ResponseData();
        AppletBrandIntroducePOExample appletBrandIntroducePOExample = new AppletBrandIntroducePOExample();
        appletBrandIntroducePOExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andValidEqualTo(Boolean.valueOf(true));
        List list = this.appletBrandIntroducePOMapper.selectByExample(appletBrandIntroducePOExample);
        if (list.size() > 0) {
            AppletBrandIntroducePO po = (AppletBrandIntroducePO)list.get(0);
            po.setImgUrl(this.qiNiuConfig.getDomain() + po.getImgUrl());
            data.setData((Object)po);
        }
        data.setMessage(SysResponseEnum.SUCCESS.getMessage());
        data.setCode(SysResponseEnum.SUCCESS.getCode());
        return data;
    }

    private ResponseData save(AppletBrandIntroducePO appletBrandIntroducePO, SysAccountPO stageUser) {
        appletBrandIntroducePO.setCreateDate(new Date());
        appletBrandIntroducePO.setCreateUserId(stageUser.getSysAccountId());
        appletBrandIntroducePO.setCreateUserName(stageUser.getName());
        appletBrandIntroducePO.setValid(Boolean.valueOf(true));
        int result = this.appletBrandIntroducePOMapper.insertSelective(appletBrandIntroducePO);
        if (result == 1) {
            return new ResponseData();
        }
        ResponseData data = new ResponseData();
        data.setCode(SysResponseEnum.FAILED.getCode());
        data.setMessage(SysResponseEnum.FAILED.getMessage());
        return data;
    }

    private ResponseData update(AppletBrandIntroducePO appletBrandIntroducePO, SysAccountPO stageUser) {
        AppletBrandIntroducePOExample appletBrandIntroducePOExample = new AppletBrandIntroducePOExample();
        appletBrandIntroducePOExample.createCriteria().andSysBrandIdEqualTo(appletBrandIntroducePO.getSysBrandId());
        AppletBrandIntroducePO po = new AppletBrandIntroducePO();
        po.setValid(Boolean.valueOf(false));
        po.setModifiedDate(new Date());
        po.setModifiedUserId(stageUser.getSysAccountId());
        po.setModifiedUserName(stageUser.getName());
        this.appletBrandIntroducePOMapper.updateByExampleSelective(po, appletBrandIntroducePOExample);
        return this.save(appletBrandIntroducePO, stageUser);
    }
}

