/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.fitmentserviceimpl.impl;

import com.bizvane.fitmentservice.interfaces.MembershipCardPrivilegeService;
import com.bizvane.fitmentservice.models.bo.AppletVipPrivilegeBO;
import com.bizvane.fitmentservice.models.po.AppletVipCartPO;
import com.bizvane.fitmentservice.models.po.AppletVipCartPOExample;
import com.bizvane.fitmentservice.models.po.AppletVipPrivilegePO;
import com.bizvane.fitmentservice.models.po.AppletVipPrivilegePOExample;
import com.bizvane.fitmentservice.models.vo.AppletVipPrivilegeVO;
import com.bizvane.fitmentservice.utils.TimeUtils;
import com.bizvane.fitmentserviceimpl.mappers.AppletVipCartPOMapper;
import com.bizvane.fitmentserviceimpl.mappers.AppletVipPrivilegePOMapper;
import com.bizvane.fitmentserviceimpl.utils.QiNiuLocation;
import com.bizvane.members.facade.models.MbrLevelModel;
import com.bizvane.members.facade.service.api.MemberLevelApiService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MembershipCardPrivilegeServiceImpl
implements MembershipCardPrivilegeService {
    @Autowired
    private AppletVipPrivilegePOMapper appletVipPrivilegePOMapper;
    @Autowired
    private AppletVipCartPOMapper appletVipCartPOMapper;
    @Autowired
    private MemberLevelApiService memberLevelApiService;

    public ResponseData selectByAppletVipCardId(Long MbrLevelId, SysAccountPO sysAccountPO) {
        ResponseData responseData = new ResponseData();
        if (MbrLevelId == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u8bf7\u8f93\u5165\u4f1a\u5458\u7b49\u7ea7id");
            return responseData;
        }
        AppletVipPrivilegeBO appletVipPrivilegeBO = new AppletVipPrivilegeBO();
        List mbrLevelModelList = this.memberLevelApiService.queryLevelList(sysAccountPO.getBrandId());
        Integer levelValue = null;
        for (MbrLevelModel mbrLevelModel : mbrLevelModelList) {
            Long mbrLevelId = mbrLevelModel.getMbrLevelId();
            if (mbrLevelId.compareTo(MbrLevelId) != 0) continue;
            levelValue = mbrLevelModel.getLevelValue();
        }
        if (levelValue == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u8be5\u7b49\u7ea7\u5bf9\u5e94\u7b49\u7ea7\u503c\u4e3a\u7a7a");
            return responseData;
        }
        appletVipPrivilegeBO.setLevelValue(levelValue);
        AppletVipCartPOExample appletVipCartPOExample = new AppletVipCartPOExample();
        appletVipCartPOExample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andGradeIdEqualTo(MbrLevelId);
        List appletVipCartPOList = this.appletVipCartPOMapper.selectByExample(appletVipCartPOExample);
        if (appletVipCartPOList != null && appletVipCartPOList.size() > 0) {
            Long appletVipCardId = ((AppletVipCartPO)appletVipCartPOList.get(0)).getAppletVipCardId();
            AppletVipPrivilegePOExample example = new AppletVipPrivilegePOExample();
            example.createCriteria().andAppletVipCardIdEqualTo(appletVipCardId).andValidEqualTo(Boolean.valueOf(true));
            List list = this.appletVipPrivilegePOMapper.selectByExample(example);
            if (list != null && list.size() > 0) {
                appletVipPrivilegeBO.setAppletVipPrivilegePOList(list);
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setData((Object)appletVipPrivilegeBO);
            } else {
                appletVipPrivilegeBO.setAppletVipPrivilegePOList(new ArrayList());
                responseData.setMessage("\u4f1a\u5458\u7279\u6743\u4e3a\u7a7a");
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setData((Object)appletVipPrivilegeBO);
            }
        } else {
            appletVipPrivilegeBO.setAppletVipPrivilegePOList(new ArrayList());
            responseData.setMessage("\u8be5\u7b49\u7ea7\u65e0\u5bf9\u5e94\u7684\u4f1a\u5458\u5361");
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setData((Object)appletVipPrivilegeBO);
        }
        return responseData;
    }

    public ResponseData<AppletVipPrivilegePO> selectByPrimaryKey(Long appletVipPrivilegeId) {
        ResponseData responseData = new ResponseData();
        if (appletVipPrivilegeId == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u8bf7\u8f93\u5165\u4f1a\u5458\u7279\u6743id");
            return responseData;
        }
        AppletVipPrivilegePO appletVipPrivilegePO = this.appletVipPrivilegePOMapper.selectByPrimaryKey(appletVipPrivilegeId);
        appletVipPrivilegePO.setPrivilegeLogo("http://" + QiNiuLocation.CENTERSTAGE.getDomain() + File.separator + appletVipPrivilegePO.getPrivilegeLogo());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)appletVipPrivilegePO);
        return responseData;
    }

    public ResponseData insertSelective(AppletVipPrivilegeVO record, SysAccountPO stageUser) {
        ResponseData responseData = this.addVipPrivilege(record, stageUser, ((AppletVipPrivilegeBO)record.getAppletVipPrivilegePOList().get(0)).getGradeId());
        if (responseData.getCode() == SysResponseEnum.FAILED.getCode()) {
            return responseData;
        }
        Integer thisLevelValue = ((AppletVipPrivilegeBO)record.getAppletVipPrivilegePOList().get(0)).getLevelValue();
        List mbrLevelModelList = this.memberLevelApiService.queryLevelList(stageUser.getBrandId());
        for (MbrLevelModel mbrLevelModel : mbrLevelModelList) {
            Integer otherLevelValue = mbrLevelModel.getLevelValue();
            if (otherLevelValue >= thisLevelValue) continue;
            Long thisGradeId = mbrLevelModel.getMbrLevelId();
            this.addVipPrivilege(record, stageUser, thisGradeId);
        }
        ResponseData responseData1 = this.selectByAppletVipCardId(((AppletVipPrivilegeBO)record.getAppletVipPrivilegePOList().get(0)).getGradeId(), stageUser);
        AppletVipPrivilegeBO list1 = (AppletVipPrivilegeBO)responseData1.getData();
        if (list1 != null) {
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setData((Object)list1);
        } else {
            responseData.setMessage("\u8be5\u7b49\u7ea7\u65e0\u5bf9\u5e94\u7684\u4f1a\u5458\u5361\u7279\u6743");
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setData((Object)list1);
        }
        return responseData;
    }

    public ResponseData addVipPrivilege(AppletVipPrivilegeVO record, SysAccountPO stageUser, Long gradeId) {
        ResponseData responseData = new ResponseData();
        if (record == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u589e\u52a0\u4fe1\u606f\u4e0d\u5f97\u4e3a\u7a7a");
            return responseData;
        }
        AppletVipCartPOExample appletVipCartPOExample = new AppletVipCartPOExample();
        appletVipCartPOExample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andGradeIdEqualTo(gradeId).andSysBrandIdEqualTo(stageUser.getBrandId()).andSysCompanyIdEqualTo(stageUser.getSysCompanyId());
        List appletVipCartPOList = this.appletVipCartPOMapper.selectByExample(appletVipCartPOExample);
        if (appletVipCartPOList == null || appletVipCartPOList.size() <= 0) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u8be5\u7b49\u7ea7\u65e0\u5bf9\u5e94\u7684\u4f1a\u5458\u5361");
            return responseData;
        }
        Long appletVipCardId = ((AppletVipCartPO)appletVipCartPOList.get(0)).getAppletVipCardId();
        AppletVipPrivilegePO appletVipPrivilegePO1 = new AppletVipPrivilegePO();
        appletVipPrivilegePO1.setModifiedDate(TimeUtils.getNowTime());
        appletVipPrivilegePO1.setModifiedUserId(stageUser.getSysAccountId());
        appletVipPrivilegePO1.setModifiedUserName(stageUser.getName());
        appletVipPrivilegePO1.setValid(Boolean.valueOf(false));
        AppletVipPrivilegePOExample appletVipPrivilegePOExample = new AppletVipPrivilegePOExample();
        appletVipPrivilegePOExample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andAppletVipCardIdEqualTo(appletVipCardId);
        int n = this.appletVipPrivilegePOMapper.updateByExampleSelective(appletVipPrivilegePO1, appletVipPrivilegePOExample);
        if (((AppletVipPrivilegeBO)record.getAppletVipPrivilegePOList().get(0)).getPrivilegeName() == null && ((AppletVipPrivilegeBO)record.getAppletVipPrivilegePOList().get(0)).getPrivilegeExplain() == null) {
            responseData.setMessage("\u65b0\u589e0\u6761\u4f1a\u5458\u5361\u7279\u6743\uff0c\u5220\u9664\u539f\u6709\u4f1a\u5458\u5361\u7279\u6743\u6210\u529f");
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            return responseData;
        }
        appletVipCardId = ((AppletVipCartPO)appletVipCartPOList.get(0)).getAppletVipCardId();
        for (AppletVipPrivilegePO appletVipPrivilegePO : record.getAppletVipPrivilegePOList()) {
            AppletVipPrivilegePO appletVipPrivilegePO2 = new AppletVipPrivilegePO();
            BeanUtils.copyProperties((Object)appletVipPrivilegePO, (Object)appletVipPrivilegePO2);
            String privilegeLogo = appletVipPrivilegePO.getPrivilegeLogo();
            appletVipPrivilegePO2.setCreateDate(TimeUtils.getNowTime());
            appletVipPrivilegePO2.setCreateUserId(stageUser.getSysAccountId());
            appletVipPrivilegePO2.setCreateUserName(stageUser.getName());
            appletVipPrivilegePO2.setPrivilegeLogo(privilegeLogo);
            appletVipPrivilegePO2.setAppletVipCardId(appletVipCardId);
            int count = this.appletVipPrivilegePOMapper.insertSelective(appletVipPrivilegePO2);
            if (count != 0) continue;
            responseData.setMessage("\u65b0\u589e\u4f1a\u5458\u5361\u7279\u6743\u5931\u8d25");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }
}

