/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.fitmentserviceimpl.impl;

import com.bizvane.fitmentservice.interfaces.MemberLevelService;
import com.bizvane.fitmentservice.models.po.AppletVipCartPO;
import com.bizvane.fitmentservice.models.po.AppletVipCartPOExample;
import com.bizvane.fitmentservice.models.vo.MbrLevelVO;
import com.bizvane.fitmentservice.utils.TimeUtils;
import com.bizvane.fitmentserviceimpl.mappers.AppletVipCartPOMapper;
import com.bizvane.members.facade.models.MbrLevelModel;
import com.bizvane.members.facade.service.api.MemberLevelApiService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MemberLevelServiceImpl
implements MemberLevelService {
    @Autowired
    private MemberLevelApiService memberLevelApiService;
    @Autowired
    private AppletVipCartPOMapper appletVipCartPOMapper;

    public ResponseData selectAllMemberCardByBrandId(Long brandId, SysAccountPO sysAccountPO, Integer code) {
        List mbrLevelModelList;
        ResponseData responseData = new ResponseData();
        if (brandId == null) {
            responseData.setMessage("\u54c1\u724cid\u4e3a\u7a7a");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        if (code == null) {
            responseData.setMessage("\u6a21\u5757code\u4e3a\u7a7a");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        if (code == 2) {
            mbrLevelModelList = this.memberLevelApiService.queryLevelList(brandId);
        } else if (code == 1) {
            mbrLevelModelList = (List)this.memberLevelApiService.queryAllLevelList(brandId).getData();
        } else {
            responseData.setMessage("\u4f20\u5165\u6a21\u5757code\u6709\u8bef");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        AppletVipCartPOExample appletVipCartPOExample = new AppletVipCartPOExample();
        appletVipCartPOExample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andSysBrandIdEqualTo(brandId);
        List appletVipCartPOList = this.appletVipCartPOMapper.selectByExample(appletVipCartPOExample);
        if (mbrLevelModelList == null || mbrLevelModelList.size() == 0) {
            responseData.setMessage("\u8be5\u54c1\u724c\u672a\u8bbe\u7f6e\u4f1a\u5458\u7b49\u7ea7");
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            return responseData;
        }
        ArrayList<Long> mbrLevelIds = new ArrayList<Long>();
        for (MbrLevelModel mbrLevelModel : mbrLevelModelList) {
            mbrLevelIds.add(mbrLevelModel.getMbrLevelId());
        }
        ArrayList<Long> appletVipCardGradeIds = null;
        if (CollectionUtils.isNotEmpty((Collection)appletVipCartPOList)) {
            appletVipCardGradeIds = new ArrayList<Long>();
            for (AppletVipCartPO appletVipCartPO : appletVipCartPOList) {
                appletVipCardGradeIds.add(appletVipCartPO.getGradeId());
            }
        }
        ArrayList<Long> addList = new ArrayList<Long>();
        addList.addAll(mbrLevelIds);
        if (appletVipCardGradeIds != null) {
            addList.removeAll(appletVipCardGradeIds);
        }
        if (addList != null && addList.size() > 0) {
            for (Long gradeId : addList) {
                AppletVipCartPO appletVipCartPO = new AppletVipCartPO();
                appletVipCartPO.setSysBrandId(brandId);
                appletVipCartPO.setGradeId(gradeId);
                appletVipCartPO.setCreateDate(TimeUtils.getNowTime());
                appletVipCartPO.setCreateUserId(sysAccountPO.getSysAccountId());
                appletVipCartPO.setCreateUserName(sysAccountPO.getName());
                appletVipCartPO.setSysCompanyId(sysAccountPO.getSysCompanyId());
                this.appletVipCartPOMapper.insertSelective(appletVipCartPO);
                responseData.setMessage("\u5411\u4f1a\u5458\u5361\u8868\u4e2d\u589e\u52a0\u65b0\u6570\u636e\u6210\u529f");
            }
        }
        AppletVipCartPOExample appletVipCartPOExample2 = new AppletVipCartPOExample();
        appletVipCartPOExample2.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andSysBrandIdEqualTo(brandId);
        List appletVipCartPOS = this.appletVipCartPOMapper.selectByExample(appletVipCartPOExample2);
        ArrayList<MbrLevelVO> mbrLevelVOS = new ArrayList<MbrLevelVO>();
        for (MbrLevelModel mbrLevelModel : mbrLevelModelList) {
            MbrLevelVO mbrLevelVO = new MbrLevelVO();
            BeanUtils.copyProperties((Object)mbrLevelModel, (Object)mbrLevelVO);
            for (AppletVipCartPO appletVipCartPO : appletVipCartPOS) {
                mbrLevelVO.setCodeType(appletVipCartPO.getCodeType());
                if (mbrLevelModel.getMbrLevelId().compareTo(appletVipCartPO.getGradeId()) != 0) continue;
                mbrLevelVO.setCardStyle(appletVipCartPO.getCardStyle());
                mbrLevelVO.setIsImg(appletVipCartPO.getIsImg());
            }
            mbrLevelVOS.add(mbrLevelVO);
        }
        if (mbrLevelVOS.size() != mbrLevelModelList.size()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u4e22\u5931\u4f1a\u5458\u7b49\u7ea7\u6570\u636e");
            responseData.setData(mbrLevelVOS);
            return responseData;
        }
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData(mbrLevelVOS);
        return responseData;
    }

    public ResponseData<AppletVipCartPO> getVipCardInfo(Long levelId, Long brandId, Long companyId) {
        AppletVipCartPOExample appletVipCartPOExample = new AppletVipCartPOExample();
        appletVipCartPOExample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andSysBrandIdEqualTo(brandId).andSysCompanyIdEqualTo(companyId);
        List appletVipCartPOList = this.appletVipCartPOMapper.selectByExample(appletVipCartPOExample);
        ResponseData responseData = new ResponseData();
        if (appletVipCartPOList != null && appletVipCartPOList.size() > 0) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setData((Object)((AppletVipCartPO)appletVipCartPOList.get(0)));
            return responseData;
        }
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        responseData.setMessage("fitment\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u6570\u636e");
        return responseData;
    }
}

