/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.fitmentserviceimpl.controllers;

import com.bizvane.fitmentservice.interfaces.MemberLevelService;
import com.bizvane.fitmentservice.interfaces.MembershipCardService;
import com.bizvane.fitmentservice.models.po.AppletVipCartPO;
import com.bizvane.fitmentservice.models.vo.AppletVipCardVo;
import com.bizvane.members.facade.service.api.MemberLevelApiService;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/membershipCard"})
public class MembershipCardController {
    @Autowired
    private MembershipCardService membershipCardService;
    @Autowired
    private MemberLevelApiService memberLevelApiService;
    @Autowired
    private MemberLevelService memberLevelService;

    @RequestMapping(value={"/updateByPrimaryKeySelective"}, method={RequestMethod.POST})
    public ResponseData updateByPrimaryKeySelective(AppletVipCartPO appletVipCartPO, HttpServletRequest request) {
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        return this.membershipCardService.updateByPrimaryKeySelective(appletVipCartPO, sysAccountPO);
    }

    @RequestMapping(value={"/selectAllMemberCardByBrandId"}, method={RequestMethod.POST})
    public ResponseData selectAllMemberCardByBrandId(Long brandId, HttpServletRequest request, Integer code) {
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        return this.memberLevelService.selectAllMemberCardByBrandId(brandId, sysAccountPO, code);
    }

    @RequestMapping(value={"/updateVipCardUpGradeInfo"})
    public ResponseData updateVipCardUpGradeInfo(AppletVipCardVo appletVipCartVO, HttpServletRequest request) {
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        return this.membershipCardService.updateVipCardUpGradeInfo(appletVipCartVO, sysAccountPO);
    }

    @RequestMapping(value={"/showVipCardUpGradeInfo"})
    public ResponseData showVipCardUpGradeInfo(HttpServletRequest request) {
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        return this.membershipCardService.showVipCardUpGradeInfo(sysAccountPO.getBrandId());
    }

    @RequestMapping(value={"/showVipCardStyle"})
    public ResponseData showVipCardStyle(Long gradeId, HttpServletRequest request) {
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        return this.membershipCardService.showVipCardStyle(gradeId, sysAccountPO);
    }

    @RequestMapping(value={"/showMemberBaseField"})
    public ResponseData showMemberBaseField(Long sysCompanyId, Long sysBrandId) {
        return this.membershipCardService.showMemberBaseField(sysCompanyId, sysBrandId);
    }

    @RequestMapping(value={"/getVipCardInfo"}, method={RequestMethod.POST})
    public ResponseData<AppletVipCartPO> getVipCardInfo(Long levelId, Long brandId, Long companyId) {
        return this.memberLevelService.getVipCardInfo(levelId, brandId, companyId);
    }
}

