package com.bizvane.fitmentservice.models.vo;

import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zcc
 * @date 2021/9/16 18:38
 **/
@Data
public class AppletBrandMicroFitmentVo implements Serializable{

    private static final long serialVersionUID = 6153236389754556834L;

    @ApiModelProperty(value = "主键",name = "appletBrandMicroFitmentId",required = false,example = "主键")
    private Long appletBrandMicroFitmentId;

    @ApiModelProperty(value = "企业id",name = "sysCompanyId",required = false,example = "企业id")
    private Long sysCompanyId;

    @ApiModelProperty(value = "品牌id",name = "sysBrandId",required = false,example = "品牌id")
    private Long sysBrandId;

    private String headerUrl;

    @ApiModelProperty(value = "主题名称",name = "headerName",required = false,example = "主题名称")
    private String headerName;

    @ApiModelProperty(value = "内容Json类型",name = "infoJson",required = false,example = "内容Json类型")
    private JSONObject infoJson;

    private Boolean valid;

    /**
     * 首页启用状态：0=禁用；1=启用(只适合首页)
     */
    private Boolean status;
    /**
     * 页面类型：0=微页面；1=首页；2-积分商城
     */
    private Integer fitmentType;

    /**
     * 背景颜色
     */
    private String bgColor;

    /**
     * 小程序类型
     */
    private Integer channelType;
}
