package com.bizvane.fitmentservice.interfaces;

import com.bizvane.fitmentservice.models.po.AppletSlideJumpPO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;

import java.util.List;

/**
 * @ClassName AppletSlideJumpService
 * @DescriptTion :
 * @Auther: wd
 * @Date :2019/4/2 14:48
 */
public interface AppletSlideJumpService {
    /**
     * 查询跳转小程序列表
     * @return
     */
    ResponseData<List<AppletSlideJumpPO>> getAppletsInfo(AppletSlideJumpPO appletSlideJumpPo);

    /**
     * 查询跳转小程序列表（分页）
     * @param appletSlideJumpPo
     * @return
     */
    ResponseData<PageInfo<AppletSlideJumpPO>> getAppletsInfoPage(AppletSlideJumpPO appletSlideJumpPo);

    /**
     * 新增跳转小程序信息
     * @param appletSlideJumpPO
     * @return
     */
    ResponseData insertAppletsInfo(AppletSlideJumpPO appletSlideJumpPo);

    /**
     * 删除跳转小程序信息
     * @param id
     * @return
     */
    ResponseData delete(Long id);

    /**
     * 获取页面名称
     * @param appid
     * @return
     */
    ResponseData<List<AppletSlideJumpPO>> getPageInfoByAppid(String appid);

    /**
     * 获取小程序appid
     * @param sysBrandId
     * @return
     */
    ResponseData<List<String>> getJumpAppIdByBrandId(Long sysBrandId);

    /**
     * 根据主键获取信息
     */
    ResponseData<AppletSlideJumpPO> getJumpAppIdByPrimaryKey(Long id);
}
