/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.dynamicdatasource.call.http;

import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.bizvane.dynamicdatasource.call.http.OkHttpProperties;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
public class RestTemplateConfig {
    @Bean
    public RestTemplate restTemplate(OkHttpProperties okHttpProperties) {
        OkHttpClient client = okHttpProperties.buildClientBuilder().addInterceptor(chain -> {
            Request originalRequest = chain.request();
            String tenantId = DynamicDataSourceContextHolder.peek();
            if (tenantId != null) {
                Request newRequest = originalRequest.newBuilder().header("tenantId", tenantId).build();
                return chain.proceed(newRequest);
            }
            return chain.proceed(originalRequest);
        }).build();
        return new RestTemplate((ClientHttpRequestFactory)new OkHttp3ClientHttpRequestFactory(client));
    }
}

