/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.dynamicdatasource.config;

import com.baomidou.dynamic.datasource.provider.AbstractJdbcDataSourceProvider;
import com.baomidou.dynamic.datasource.provider.DynamicDataSourceProvider;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import feign.RequestInterceptor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextHolder;

@Configuration
public class DynamicDataSourceConfig {
    @Bean
    public DynamicDataSourceProvider dynamicDataSourceProvider(DynamicDataSourceProperties properties) {
        final Map datasourceMap = properties.getDatasource();
        DataSourceProperty masterDataSourceProperty = (DataSourceProperty)datasourceMap.get(properties.getPrimary());
        return new AbstractJdbcDataSourceProvider(masterDataSourceProperty.getDriverClassName(), masterDataSourceProperty.getUrl(), masterDataSourceProperty.getUsername(), masterDataSourceProperty.getPassword()){

            protected Map<String, DataSourceProperty> executeStmt(Statement statement) {
                try (ResultSet resultSet = statement.executeQuery(" SELECT tenant_id, url, username, password, driver_class_name FROM t_sys_tenant_data_sources where valid = 1 and status = 1");){
                    while (resultSet.next()) {
                        String tenantId = resultSet.getString("tenant_id");
                        String username = resultSet.getString("username");
                        String password = resultSet.getString("password");
                        String url = resultSet.getString("url");
                        String driver = resultSet.getString("driver_class_name");
                        DynamicDataSourceConfig.this.addDatasource(tenantId, username, password, url, driver, datasourceMap);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                return datasourceMap;
            }
        };
    }

    @Bean
    @Qualifier(value="primary")
    public DataSource primaryDataSource(DynamicDataSourceProperties properties) {
        DataSourceProperty masterDataSourceProperty = (DataSourceProperty)properties.getDatasource().get(properties.getPrimary());
        return DataSourceBuilder.create().driverClassName(masterDataSourceProperty.getDriverClassName()).url(masterDataSourceProperty.getUrl()).username(masterDataSourceProperty.getUsername()).password(masterDataSourceProperty.getPassword()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDatasource(String tenantId, String username, String password, String url, String driver, Map<String, DataSourceProperty> datasourceMap) {
        if (!datasourceMap.isEmpty() && !datasourceMap.containsKey(tenantId)) {
            DynamicDataSourceConfig dynamicDataSourceConfig = this;
            synchronized (dynamicDataSourceConfig) {
                if (!datasourceMap.containsKey(tenantId)) {
                    DataSourceProperty property = new DataSourceProperty();
                    property.setUsername(username);
                    property.setUrl(url);
                    property.setDriverClassName(driver);
                    property.setPassword(password);
                    datasourceMap.put(tenantId, property);
                }
            }
        }
    }

    @Bean
    public RequestInterceptor tenantIdFeignInterceptor() {
        return requestTemplate -> {
            String tenantId = DynamicDataSourceContextHolder.peek();
            if (tenantId == null) {
                tenantId = String.valueOf(Objects.requireNonNull(RequestContextHolder.getRequestAttributes()).getAttribute("tenantId", 0));
            }
            requestTemplate.header("tenantId", new String[]{tenantId});
        };
    }
}

