/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.dynamicdatasource.call.http;

import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="tenant.okhttp.client")
public class OkHttpProperties {
    private long connectTimeout = 60L;
    private long readTimeout = 60L;
    private long writeTimeout = 60L;
    private int maxIdleConnections = 50;
    private long keepAliveDuration = 600L;

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(long writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public int getMaxIdleConnections() {
        return this.maxIdleConnections;
    }

    public void setMaxIdleConnections(int maxIdleConnections) {
        this.maxIdleConnections = maxIdleConnections;
    }

    public long getKeepAliveDuration() {
        return this.keepAliveDuration;
    }

    public void setKeepAliveDuration(long keepAliveDuration) {
        this.keepAliveDuration = keepAliveDuration;
    }

    public OkHttpClient.Builder buildClientBuilder() {
        ConnectionPool connectionPool = new ConnectionPool(this.maxIdleConnections, this.keepAliveDuration, TimeUnit.SECONDS);
        return new OkHttpClient.Builder().connectTimeout(this.connectTimeout, TimeUnit.SECONDS).readTimeout(this.readTimeout, TimeUnit.SECONDS).writeTimeout(this.writeTimeout, TimeUnit.SECONDS).connectionPool(connectionPool);
    }
}

